/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.matchers.Times;
import software.xdev.mockserver.serialization.model.DTO;

public class TimesDTO
implements DTO<Times> {
    private int remainingTimes;
    private boolean unlimited;

    public TimesDTO(Times times) {
        this.remainingTimes = times.getRemainingTimes();
        this.unlimited = times.isUnlimited();
    }

    public TimesDTO() {
    }

    @Override
    public Times buildObject() {
        if (this.unlimited) {
            return Times.unlimited();
        }
        return Times.exactly(this.remainingTimes);
    }

    public int getRemainingTimes() {
        return this.remainingTimes;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimesDTO)) {
            return false;
        }
        TimesDTO timesDTO = (TimesDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.getRemainingTimes() == timesDTO.getRemainingTimes() && this.isUnlimited() == timesDTO.isUnlimited();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRemainingTimes(), this.isUnlimited());
    }
}

