/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.serialization.model.BodyWithContentTypeDTO;
import software.xdev.mockserver.serialization.model.ConnectionOptionsDTO;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class HttpResponseDTO
implements DTO<HttpResponse> {
    private Integer statusCode;
    private String reasonPhrase;
    private BodyWithContentTypeDTO body;
    private Cookies cookies;
    private Headers headers;
    private DelayDTO delay;
    private ConnectionOptionsDTO connectionOptions;

    public HttpResponseDTO() {
    }

    public HttpResponseDTO(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.statusCode = httpResponse.getStatusCode();
            this.reasonPhrase = httpResponse.getReasonPhrase();
            this.body = BodyWithContentTypeDTO.createWithContentTypeDTO(httpResponse.getBody());
            this.headers = httpResponse.getHeaders();
            this.cookies = httpResponse.getCookies();
            this.delay = httpResponse.getDelay() != null ? new DelayDTO(httpResponse.getDelay()) : null;
            this.connectionOptions = httpResponse.getConnectionOptions() != null ? new ConnectionOptionsDTO(httpResponse.getConnectionOptions()) : null;
        }
    }

    @Override
    public HttpResponse buildObject() {
        return ((HttpResponse)new HttpResponse().withStatusCode(this.statusCode).withReasonPhrase(this.reasonPhrase).withBody((BodyWithContentType)(this.body != null ? this.body.buildObject() : null)).withHeaders(this.headers).withCookies(this.cookies).withDelay(this.delay != null ? this.delay.buildObject() : null)).withConnectionOptions(this.connectionOptions != null ? this.connectionOptions.buildObject() : null);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponseDTO setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public HttpResponseDTO setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public BodyWithContentTypeDTO getBody() {
        return this.body;
    }

    public HttpResponseDTO setBody(BodyWithContentTypeDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpResponseDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpResponseDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpResponseDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }

    public ConnectionOptionsDTO getConnectionOptions() {
        return this.connectionOptions;
    }

    public HttpResponseDTO setConnectionOptions(ConnectionOptionsDTO connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpResponseDTO)) {
            return false;
        }
        HttpResponseDTO that = (HttpResponseDTO)o;
        return Objects.equals(this.getStatusCode(), that.getStatusCode()) && Objects.equals(this.getReasonPhrase(), that.getReasonPhrase()) && Objects.equals(this.getBody(), that.getBody()) && Objects.equals(this.getCookies(), that.getCookies()) && Objects.equals(this.getHeaders(), that.getHeaders()) && Objects.equals(this.getDelay(), that.getDelay()) && Objects.equals(this.getConnectionOptions(), that.getConnectionOptions());
    }

    public int hashCode() {
        return Objects.hash(this.getStatusCode(), this.getReasonPhrase(), this.getBody(), this.getCookies(), this.getHeaders(), this.getDelay(), this.getConnectionOptions());
    }
}

