/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Arrays;
import java.util.Objects;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class HttpErrorDTO
implements DTO<HttpError> {
    private DelayDTO delay;
    private Boolean dropConnection;
    private byte[] responseBytes;

    public HttpErrorDTO(HttpError httpError) {
        if (httpError != null) {
            if (httpError.getDelay() != null) {
                this.delay = new DelayDTO(httpError.getDelay());
            }
            this.dropConnection = httpError.getDropConnection();
            this.responseBytes = httpError.getResponseBytes();
        }
    }

    public HttpErrorDTO() {
    }

    @Override
    public HttpError buildObject() {
        return ((HttpError)new HttpError().withDelay(this.delay != null ? this.delay.buildObject() : null)).withDropConnection(this.dropConnection).withResponseBytes(this.responseBytes);
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpErrorDTO setDelay(DelayDTO host) {
        this.delay = host;
        return this;
    }

    public Boolean getDropConnection() {
        return this.dropConnection;
    }

    public HttpErrorDTO setDropConnection(Boolean port) {
        this.dropConnection = port;
        return this;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public HttpErrorDTO setResponseBytes(byte[] scheme) {
        this.responseBytes = scheme;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpErrorDTO)) {
            return false;
        }
        HttpErrorDTO that = (HttpErrorDTO)o;
        return Objects.equals(this.getDelay(), that.getDelay()) && Objects.equals(this.getDropConnection(), that.getDropConnection()) && Objects.deepEquals(this.getResponseBytes(), that.getResponseBytes());
    }

    public int hashCode() {
        return Objects.hash(this.getDelay(), this.getDropConnection(), Arrays.hashCode(this.getResponseBytes()));
    }
}

