/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.HttpResponseDTO;
import software.xdev.mockserver.util.StringUtils;

public class HttpResponseSerializer
implements Serializer<HttpResponse> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    @Override
    public String serialize(HttpResponse httpResponse) {
        try {
            return this.objectWriter.writeValueAsString((Object)new HttpResponseDTO(httpResponse));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing httpResponse to JSON with value " + String.valueOf(httpResponse), e);
        }
    }

    @Override
    public String serialize(List<HttpResponse> httpResponses) {
        return this.serialize(httpResponses.toArray(new HttpResponse[0]));
    }

    @Override
    public String serialize(HttpResponse ... httpResponses) {
        try {
            if (httpResponses != null && httpResponses.length > 0) {
                HttpResponseDTO[] httpResponseDTOs = new HttpResponseDTO[httpResponses.length];
                for (int i = 0; i < httpResponses.length; ++i) {
                    httpResponseDTOs[i] = new HttpResponseDTO(httpResponses[i]);
                }
                return this.objectWriter.writeValueAsString((Object)httpResponseDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing HttpResponse to JSON with value " + String.valueOf(Arrays.asList(httpResponses)), e);
        }
    }

    @Override
    public HttpResponse deserialize(String jsonHttpResponse) {
        if (jsonHttpResponse.contains("\"httpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpResponse);
                if (jsonNode.has("httpResponse")) {
                    jsonHttpResponse = jsonNode.get("httpResponse").toString();
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("exception while parsing [" + jsonHttpResponse + "] for HttpResponse", ex);
            }
        }
        HttpResponse httpResponse = null;
        try {
            HttpResponseDTO httpResponseDTO = (HttpResponseDTO)this.objectMapper.readValue(jsonHttpResponse, HttpResponseDTO.class);
            if (httpResponseDTO != null) {
                httpResponse = httpResponseDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonHttpResponse + "] for HttpResponse", ex);
        }
        return httpResponse;
    }

    @Override
    public Class<HttpResponse> supportsType() {
        return HttpResponse.class;
    }

    public HttpResponse[] deserializeArray(String jsonHttpResponses) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        if (StringUtils.isBlank(jsonHttpResponses)) {
            throw new IllegalArgumentException("1 error:\n - a response or response array is required but value was \"" + jsonHttpResponses + "\"");
        }
        List<String> jsonResponseList = this.jsonArraySerializer.splitJSONArray(jsonHttpResponses);
        if (jsonResponseList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a response or array of response is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpectation : jsonResponseList) {
            try {
                httpResponses.add(this.deserialize(jsonExpectation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpResponses.toArray(new HttpResponse[0]);
    }
}

