/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.util.StringUtils;

public class ExpectationIdSerializer
implements Serializer<ExpectationId> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    @Override
    public String serialize(ExpectationId expectationId) {
        try {
            return this.objectWriter.writeValueAsString((Object)expectationId);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing ExpectationId to JSON with value " + String.valueOf(expectationId), e);
        }
    }

    @Override
    public String serialize(List<? extends ExpectationId> expectationIds) {
        return this.serialize(expectationIds.toArray(new ExpectationId[0]));
    }

    @Override
    public String serialize(ExpectationId ... expectationIds) {
        try {
            if (expectationIds != null && expectationIds.length > 0) {
                return this.objectWriter.writeValueAsString((Object)expectationIds);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing ExpectationId to JSON with value " + String.valueOf(Arrays.asList(expectationIds)), e);
        }
    }

    @Override
    public ExpectationId deserialize(String jsonExpectationId) {
        try {
            JsonNode jsonNode;
            if (jsonExpectationId.contains("\"httpRequest\"")) {
                JsonNode jsonNode2 = this.objectMapper.readTree(jsonExpectationId);
                if (jsonNode2.has("httpRequest")) {
                    jsonExpectationId = jsonNode2.get("httpRequest").toString();
                }
            } else if (jsonExpectationId.contains("\"openAPIDefinition\"") && (jsonNode = this.objectMapper.readTree(jsonExpectationId)).has("openAPIDefinition")) {
                jsonExpectationId = jsonNode.get("openAPIDefinition").toString();
            }
            return (ExpectationId)this.objectMapper.readValue(jsonExpectationId, ExpectationId.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonExpectationId + "] for ExpectationId", ex);
        }
    }

    @Override
    public Class<ExpectationId> supportsType() {
        return ExpectationId.class;
    }

    public ExpectationId[] deserializeArray(String jsonExpectationIds) {
        ArrayList<ExpectationId> expectationIds = new ArrayList<ExpectationId>();
        if (StringUtils.isBlank(jsonExpectationIds)) {
            throw new IllegalArgumentException("1 error:\n - a request or request array is required but value was \"" + jsonExpectationIds + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonExpectationIds);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                expectationIds.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return expectationIds.toArray(new ExpectationId[0]);
    }
}

