/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.logging;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class BinaryArrayFormatter {
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);

    public static String byteArrayToString(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return "base64:\n  " + BinaryArrayFormatter.formatFixedLength(Base64.getEncoder().encodeToString(bytes)) + "\nhex:\n  " + BinaryArrayFormatter.formatFixedLength(BinaryArrayFormatter.bytesToHex(bytes));
        }
        return "base64:\n\nhex:\n";
    }

    private static String formatFixedLength(String s) {
        return String.join((CharSequence)"\n", s.split("(?<=\\G.{64})"));
    }

    private static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    private BinaryArrayFormatter() {
    }
}

