/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.client;

import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MockServerClientEventBus {
    protected final Map<EventType, Set<SubscriberHandler>> subscribers = new EnumMap<EventType, Set<SubscriberHandler>>(EventType.class);

    protected void publish(EventType event) {
        Set<SubscriberHandler> subscriberHandlers = this.subscribers.get((Object)event);
        if (subscriberHandlers == null) {
            return;
        }
        for (SubscriberHandler subscriber : subscriberHandlers) {
            subscriber.handle();
        }
    }

    public void subscribe(SubscriberHandler subscriber, EventType ... events) {
        for (EventType event : events) {
            this.subscribers.computeIfAbsent(event, x -> new LinkedHashSet()).add(subscriber);
        }
    }

    public static enum EventType {
        STOP,
        RESET;

    }

    public static interface SubscriberHandler {
        public void handle();
    }
}

