/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.shading.org.postgresql.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.HostSpec;

public class Util {
    private static final Pattern URL_PATTERN = Pattern.compile("^(?<host>.*?)(?::(?<port>[^:]*))?$");
    private static @Nullable String shadingPrefix = null;
    private static final Object lockObj = new Object();
    private static final ConcurrentMap<Class<?>, Boolean> isJdbcInterfaceCache = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Class<?>[]> getImplementedInterfacesCache = new ConcurrentHashMap();

    public static String getPackageName(Class<?> clazz) {
        String fqcn = clazz.getName();
        int classNameStartsAt = fqcn.lastIndexOf(46);
        if (classNameStartsAt > 0) {
            return fqcn.substring(0, classNameStartsAt);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String shadingPrefix(String clazzName) {
        if (shadingPrefix == null) {
            Object object = lockObj;
            synchronized (object) {
                if (shadingPrefix == null) {
                    shadingPrefix = Util.getPackageName(Util.class).replaceAll("software.aws.rds.jdbc.postgresql.shading.org.postgresql.util", "");
                }
            }
        }
        if ("".equals(shadingPrefix)) {
            return clazzName;
        }
        return shadingPrefix + clazzName;
    }

    public static boolean isJdbcInterface(Class<?> clazz) {
        if (isJdbcInterfaceCache.containsKey(clazz)) {
            return (Boolean)isJdbcInterfaceCache.get(clazz);
        }
        if (clazz.isInterface()) {
            try {
                Package classPackage = clazz.getPackage();
                if (classPackage != null && Util.isJdbcPackage(classPackage.getName())) {
                    isJdbcInterfaceCache.putIfAbsent(clazz, true);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!Util.isJdbcInterface(iface)) continue;
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        if (clazz.getSuperclass() != null && Util.isJdbcInterface(clazz.getSuperclass())) {
            isJdbcInterfaceCache.putIfAbsent(clazz, true);
            return true;
        }
        isJdbcInterfaceCache.putIfAbsent(clazz, false);
        return false;
    }

    public static boolean isJdbcPackage(@Nullable String packageName) {
        return packageName != null && (packageName.startsWith("java.sql") || packageName.startsWith("javax.sql") || packageName.startsWith(Util.shadingPrefix("software.aws.rds.jdbc.postgresql.shading.org.postgresql")));
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        Class[] implementedInterfaces = (Class[])getImplementedInterfacesCache.get(clazz);
        if (implementedInterfaces != null) {
            return implementedInterfaces;
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> superClass = clazz;
        do {
            Collections.addAll(interfaces, superClass.getInterfaces());
        } while ((superClass = superClass.getSuperclass()) != null);
        implementedInterfaces = interfaces.toArray(new Class[0]);
        Class[] oldValue = getImplementedInterfacesCache.putIfAbsent(clazz, implementedInterfaces);
        if (oldValue != null) {
            implementedInterfaces = oldValue;
        }
        return implementedInterfaces;
    }

    public static String stackTraceToString(Throwable t, Class callingClass) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n\n========== [");
        buffer.append(callingClass.getName());
        buffer.append("]: Exception Detected: ==========\n\n");
        buffer.append(t.getClass().getName());
        String exceptionMessage = t.getMessage();
        if (exceptionMessage != null) {
            buffer.append("Message: ");
            buffer.append(exceptionMessage);
        }
        StringWriter out = new StringWriter();
        PrintWriter printOut = new PrintWriter(out);
        t.printStackTrace(printOut);
        buffer.append("Stack Trace:\n\n");
        buffer.append(out.toString());
        buffer.append("============================\n\n\n");
        return buffer.toString();
    }

    public static @Nullable HostSpec parseUrl(@Nullable String url) {
        if (Util.isNullOrEmpty(url)) {
            return null;
        }
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        String hostName = matcher.group("host");
        String portAsString = Util.getUtf(matcher.group("port"));
        if (Util.isNullOrEmpty(hostName)) {
            return null;
        }
        int portAsInteger = -1;
        if (!Util.isNullOrEmpty(portAsString)) {
            try {
                portAsInteger = Integer.parseInt(portAsString.trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new HostSpec(hostName.trim(), portAsInteger);
    }

    private static @Nullable String getUtf(@Nullable String url) {
        if (Util.isNullOrEmpty(url)) {
            return url;
        }
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=false)
    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.equals("");
    }
}

