/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.shading.org.postgresql.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpiringCache<K, V>
implements Map<K, V> {
    private int expireTimeMs;
    private final LinkedHashMap<K, Hit<V>> linkedHashMap = new LinkedHashMap<K, Hit<V>>(1, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Hit<V>> eldest) {
            if (eldest.getValue().isExpire(ExpiringCache.this.expireTimeMs)) {
                Iterator i = this.values().iterator();
                i.next();
                do {
                    i.remove();
                } while (i.hasNext() && ((Hit)i.next()).isExpire(ExpiringCache.this.expireTimeMs));
            }
            return false;
        }
    };

    public ExpiringCache(int expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public void setExpireTime(int expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public int getExpireTime() {
        return this.expireTimeMs;
    }

    @Override
    public int size() {
        return (int)this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).count();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedHashMap.values().stream().allMatch(x -> x.isExpire(this.expireTimeMs));
    }

    @Override
    public boolean containsKey(Object key) {
        V payload = this.get(key);
        return payload != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.linkedHashMap.values().stream().anyMatch(x -> !x.isExpire(this.expireTimeMs) && ((Hit)x).payload == value);
    }

    @Override
    public @Nullable V get(Object key) {
        Hit<V> hit = this.linkedHashMap.get(key);
        if (hit == null) {
            return null;
        }
        if (hit.isExpire(this.expireTimeMs)) {
            this.linkedHashMap.remove(key);
            return null;
        }
        return (V)((Hit)hit).payload;
    }

    @Override
    public @Nullable V put(K key, V value) {
        Hit<V> prevValue = this.linkedHashMap.put(key, new Hit<V>(value));
        return (V)(prevValue == null ? null : ((Hit)prevValue).payload);
    }

    @Override
    public @Nullable V remove(Object key) {
        Hit prevValue = (Hit)this.linkedHashMap.remove(key);
        return (V)(prevValue == null ? null : prevValue.payload);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.linkedHashMap.put(entry.getKey(), new Hit<V>(entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.linkedHashMap.clear();
    }

    @Override
    public Set<@KeyFor(value={"this"}) K> keySet() {
        return this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        return this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).map(x -> ((Hit)x).payload).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet() {
        return this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(x -> new AbstractMap.SimpleEntry(x.getKey(), ((Hit)x.getValue()).payload)).collect(Collectors.toSet());
    }

    private static class Hit<V> {
        private final long time = System.currentTimeMillis();
        private final V payload;

        Hit(V payload) {
            this.payload = payload;
        }

        boolean isExpire(int expireTimeMs) {
            return System.currentTimeMillis() - this.time >= (long)expireTimeMs;
        }
    }
}

