/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.shading.org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.geometric.PGpoint;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.GT;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PGobject;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PGtokenizer;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLException;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLState;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public @Nullable PGpoint center;
    public double radius;

    public PGcircle(double x, double y, double r) {
        this(new PGpoint(x, y), r);
    }

    public PGcircle(PGpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public PGcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGcircle() {
        this.type = "circle";
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p = (PGcircle)obj;
            return p.radius == this.radius && PGcircle.equals(p.center, this.center);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.radius);
        int v = (int)(bits ^ bits >>> 32);
        if (this.center != null) {
            v = v * 31 + this.center.hashCode();
        }
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGcircle newPGcircle = (PGcircle)super.clone();
        if (newPGcircle.center != null) {
            newPGcircle.center = (PGpoint)newPGcircle.center.clone();
        }
        return newPGcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

