/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca.metrics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareHitMissMetricsHolder;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareMetricsReporter;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareTimeMetricsHolder;

public class ClusterAwareMetrics {
    private final ClusterAwareMetricsReporter<Long> failureDetection = new ClusterAwareTimeMetricsHolder("Failover Detection");
    private final ClusterAwareMetricsReporter<Long> writerFailoverProcedure = new ClusterAwareTimeMetricsHolder("Writer Failover Procedure");
    private final ClusterAwareMetricsReporter<Long> readerFailoverProcedure = new ClusterAwareTimeMetricsHolder("Reader Failover Procedure");
    private final ClusterAwareMetricsReporter<Long> queryTopology = new ClusterAwareTimeMetricsHolder("Topology Query");
    private final ClusterAwareMetricsReporter<Boolean> failoverConnects = new ClusterAwareHitMissMetricsHolder("Successful Failover Reconnects");
    private final List<ClusterAwareMetricsReporter<? extends Serializable>> reporters = Arrays.asList(this.failureDetection, this.writerFailoverProcedure, this.readerFailoverProcedure, this.queryTopology, this.failoverConnects);

    public void registerFailureDetectionTime(long timeMs) {
        this.failureDetection.register(timeMs);
    }

    public void registerWriterFailoverProcedureTime(long timeMs) {
        this.writerFailoverProcedure.register(timeMs);
    }

    public void registerReaderFailoverProcedureTime(long timeMs) {
        this.readerFailoverProcedure.register(timeMs);
    }

    public void registerTopologyQueryTime(long timeMs) {
        this.queryTopology.register(timeMs);
    }

    public void registerFailoverConnects(boolean isHit) {
        this.failoverConnects.register(isHit);
    }

    public void reportMetrics(Logger log) {
        this.reporters.forEach(report -> report.reportMetrics(log));
    }
}

