/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.ca.HostInfo;
import software.aws.rds.jdbc.postgresql.ca.TopologyService;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareMetrics;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.ExpiringCache;

public class AuroraTopologyService
implements TopologyService {
    static final int DEFAULT_REFRESH_RATE_IN_MILLISECONDS = 30000;
    static final int DEFAULT_CACHE_EXPIRE_MS = 300000;
    static final int WRITER_CONNECTION_INDEX = 0;
    private int refreshRateInMilliseconds;
    static final String RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID FROM aurora_replica_status() WHERE EXTRACT(EPOCH FROM(NOW() - LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ORDER BY LAST_UPDATE_TIMESTAMP DESC";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String SERVER_ID_COL = "SERVER_ID";
    static final String SESSION_ID_COL = "SESSION_ID";
    protected static final ExpiringCache<String, ClusterTopologyInfo> topologyCache = new ExpiringCache(300000);
    private static final Object cacheLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(AuroraTopologyService.class.getName());
    protected String clusterId;
    protected HostInfo clusterInstanceTemplate;
    protected @MonotonicNonNull ClusterAwareMetrics metrics = null;
    protected boolean gatherPerfMetrics;

    public AuroraTopologyService() {
        this(30000);
    }

    public AuroraTopologyService(int refreshRateInMilliseconds) {
        this.refreshRateInMilliseconds = refreshRateInMilliseconds;
        this.clusterId = UUID.randomUUID().toString();
        this.clusterInstanceTemplate = new HostInfo("?", null, -1, false);
    }

    public void setPerformanceMetrics(ClusterAwareMetrics metrics, boolean gatherMetrics) {
        this.metrics = metrics;
        this.gatherPerfMetrics = gatherMetrics;
    }

    public static void setExpireTime(int expireTimeMs) {
        topologyCache.setExpireTime(expireTimeMs);
    }

    @Override
    public void setClusterId(String clusterId) {
        LOGGER.log(Level.FINER, "[AuroraTopologyService] clusterId=''{0}''", clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public void setClusterInstanceTemplate(HostInfo clusterInstanceTemplate) {
        LOGGER.log(Level.FINER, "[AuroraTopologyService] clusterInstance host=''{0}'', port={1,number,#}", new Object[]{clusterInstanceTemplate.getHost(), clusterInstanceTemplate.getPort()});
        this.clusterInstanceTemplate = clusterInstanceTemplate;
    }

    @Override
    public List<HostInfo> getTopology(Connection conn, boolean forceUpdate) {
        ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
        if (clusterTopologyInfo == null || clusterTopologyInfo.hosts.isEmpty() || forceUpdate || this.refreshNeeded(clusterTopologyInfo)) {
            ClusterTopologyInfo latestTopologyInfo = this.queryForTopology(conn);
            if (!latestTopologyInfo.hosts.isEmpty()) {
                clusterTopologyInfo = this.updateCache(clusterTopologyInfo, latestTopologyInfo);
            } else {
                return clusterTopologyInfo == null || forceUpdate ? new ArrayList() : clusterTopologyInfo.hosts;
            }
        }
        return clusterTopologyInfo.hosts;
    }

    private boolean refreshNeeded(ClusterTopologyInfo info) {
        Instant lastUpdateTime = info.lastUpdated;
        return info.hosts.isEmpty() || Duration.between(lastUpdateTime, Instant.now()).toMillis() > (long)this.refreshRateInMilliseconds;
    }

    protected ClusterTopologyInfo queryForTopology(Connection conn) {
        long startTimeMs = this.gatherPerfMetrics ? System.currentTimeMillis() : 0L;
        List<HostInfo> hosts = new ArrayList<HostInfo>();
        try (Statement stmt2 = conn.createStatement();
             ResultSet resultSet = stmt2.executeQuery(RETRIEVE_TOPOLOGY_SQL);){
            hosts = this.processQueryResults(resultSet);
        }
        catch (SQLException stmt2) {
            // empty catch block
        }
        if (this.metrics != null && this.gatherPerfMetrics) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerTopologyQueryTime(currentTimeMs - startTimeMs);
        }
        return new ClusterTopologyInfo(hosts, new HashSet<String>(), null, Instant.now());
    }

    private List<HostInfo> processQueryResults(ResultSet resultSet) throws SQLException {
        int writerCount = 0;
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        while (resultSet.next()) {
            if (!WRITER_SESSION_ID.equalsIgnoreCase(resultSet.getString(SESSION_ID_COL))) {
                hosts.add(this.createHost(resultSet));
                continue;
            }
            if (writerCount == 0) {
                hosts.add(0, this.createHost(resultSet));
            } else {
                hosts.add(this.createHost(resultSet, false));
            }
            ++writerCount;
        }
        if (writerCount == 0) {
            LOGGER.log(Level.SEVERE, "[AuroraTopologyService] The topology query returned an invalid topology - no writer instance detected");
            hosts.clear();
        }
        return hosts;
    }

    private HostInfo createHost(ResultSet resultSet) throws SQLException {
        return this.createHost(resultSet, WRITER_SESSION_ID.equals(resultSet.getString(SESSION_ID_COL)));
    }

    private HostInfo createHost(ResultSet resultSet, boolean isWriter) throws SQLException {
        String hostName = resultSet.getString(SERVER_ID_COL);
        hostName = hostName == null ? "NULL" : hostName;
        return new HostInfo(this.getHostEndpoint(hostName), hostName, this.clusterInstanceTemplate.getPort(), isWriter);
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterTopologyInfo updateCache(@Nullable ClusterTopologyInfo clusterTopologyInfo, ClusterTopologyInfo latestTopologyInfo) {
        if (clusterTopologyInfo == null) {
            clusterTopologyInfo = latestTopologyInfo;
        } else {
            clusterTopologyInfo.hosts = latestTopologyInfo.hosts;
            clusterTopologyInfo.downHosts = latestTopologyInfo.downHosts;
        }
        clusterTopologyInfo.lastUpdated = Instant.now();
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.put(this.clusterId, clusterTopologyInfo);
        }
        return clusterTopologyInfo;
    }

    @Override
    public @Nullable List<HostInfo> getCachedTopology() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.hosts;
    }

    @Override
    public @Nullable HostInfo getLastUsedReaderHost() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.lastUsedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUsedReaderHost(@Nullable HostInfo reader) {
        if (reader != null) {
            Object object = cacheLock;
            synchronized (object) {
                ClusterTopologyInfo info = topologyCache.get(this.clusterId);
                if (info != null) {
                    info.lastUsedReader = reader;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDownHosts() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null ? clusterTopologyInfo.downHosts : new HashSet<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToDownHostList(@Nullable HostInfo downHost) {
        if (downHost == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo == null) {
                clusterTopologyInfo = new ClusterTopologyInfo(new ArrayList<HostInfo>(), new HashSet<String>(), null, Instant.now());
                topologyCache.put(this.clusterId, clusterTopologyInfo);
            }
            clusterTopologyInfo.downHosts.add(downHost.getHostPortPair());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDownHostList(@Nullable HostInfo host) {
        if (host == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo != null) {
                clusterTopologyInfo.downHosts.remove(host.getHostPortPair());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshRate(int refreshRate) {
        this.refreshRateInMilliseconds = refreshRate;
        if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
            Object object = cacheLock;
            synchronized (object) {
                if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
                    topologyCache.setExpireTime(this.refreshRateInMilliseconds);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.remove(this.clusterId);
        }
    }

    private static class ClusterTopologyInfo {
        public List<HostInfo> hosts;
        public Set<String> downHosts;
        public @Nullable HostInfo lastUsedReader;
        public Instant lastUpdated;

        ClusterTopologyInfo(List<HostInfo> hosts, Set<String> downHosts, @Nullable HostInfo lastUsedReader, Instant lastUpdated) {
            this.hosts = hosts;
            this.downHosts = downHosts;
            this.lastUsedReader = lastUsedReader;
            this.lastUpdated = lastUpdated;
        }
    }
}

