/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class Monitor
implements IMonitor {
    private static final int THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100;
    private static final int MIN_CONNECTION_CHECK_TIMEOUT_MILLIS = 3000;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    private final Queue<MonitorConnectionContext> activeContexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final Queue<MonitorConnectionContext> newContexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final IConnectionProvider connectionProvider;
    private final Log logger;
    private final PropertySet propertySet;
    private final HostInfo hostInfo;
    private final IMonitorService monitorService;
    private volatile long contextLastUsedTimestampNano;
    private volatile boolean stopped = false;
    private final long monitorDisposalTimeMillis;
    private Connection monitoringConn = null;
    private long nodeCheckTimeoutMillis = 3000L;

    public Monitor(IConnectionProvider connectionProvider, HostInfo hostInfo, PropertySet propertySet, long monitorDisposalTimeMillis, IMonitorService monitorService, Log logger) {
        this.connectionProvider = connectionProvider;
        this.hostInfo = hostInfo;
        this.propertySet = propertySet;
        this.logger = logger;
        this.monitorDisposalTimeMillis = monitorDisposalTimeMillis;
        this.monitorService = monitorService;
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    @Override
    public void startMonitoring(MonitorConnectionContext context) {
        long currentTimeNano = this.getCurrentTimeNano();
        context.setStartMonitorTimeNano(currentTimeNano);
        this.contextLastUsedTimestampNano = currentTimeNano;
        this.newContexts.add(context);
    }

    @Override
    public void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            this.logger.logWarn(NullArgumentMessage.getMessage("context"));
            return;
        }
        context.setInactive();
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
    }

    @Override
    public synchronized void clearContexts() {
        this.newContexts.clear();
        this.activeContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped = false;
            while (true) {
                MonitorConnectionContext newMonitorContext;
                MonitorConnectionContext firstAddedNewMonitorContext = null;
                long currentTimeNano = this.getCurrentTimeNano();
                while ((newMonitorContext = this.newContexts.poll()) != null) {
                    if (firstAddedNewMonitorContext == newMonitorContext) {
                        this.newContexts.add(newMonitorContext);
                        break;
                    }
                    if (!newMonitorContext.isActiveContext()) continue;
                    if (newMonitorContext.getExpectedActiveMonitoringStartTimeNano() > currentTimeNano) {
                        this.newContexts.add(newMonitorContext);
                        if (firstAddedNewMonitorContext != null) continue;
                        firstAddedNewMonitorContext = newMonitorContext;
                        continue;
                    }
                    this.activeContexts.add(newMonitorContext);
                }
                if (!this.activeContexts.isEmpty()) {
                    MonitorConnectionContext monitorContext;
                    long statusCheckStartTimeNano;
                    this.contextLastUsedTimestampNano = statusCheckStartTimeNano = this.getCurrentTimeNano();
                    ConnectionStatus status = this.checkConnectionStatus(this.nodeCheckTimeoutMillis);
                    long delayMillis = -1L;
                    MonitorConnectionContext firstAddedMonitorContext = null;
                    while ((monitorContext = this.activeContexts.poll()) != null) {
                        MonitorConnectionContext monitorConnectionContext = monitorContext;
                        synchronized (monitorConnectionContext) {
                            if (!monitorContext.isActiveContext()) {
                                continue;
                            }
                            if (firstAddedMonitorContext == monitorContext) {
                                this.activeContexts.add(monitorContext);
                                break;
                            }
                            monitorContext.updateConnectionStatus(this.hostInfo.getHostPortPair(), statusCheckStartTimeNano, statusCheckStartTimeNano + status.elapsedTimeNano, status.isValid);
                            if (monitorContext.isActiveContext() && !monitorContext.isNodeUnhealthy()) {
                                this.activeContexts.add(monitorContext);
                                if (firstAddedMonitorContext == null) {
                                    firstAddedMonitorContext = monitorContext;
                                }
                                if (delayMillis == -1L || delayMillis > (long)monitorContext.getFailureDetectionIntervalMillis()) {
                                    delayMillis = monitorContext.getFailureDetectionIntervalMillis();
                                }
                            }
                        }
                    }
                    if (delayMillis == -1L) {
                        delayMillis = 100L;
                    } else {
                        if ((delayMillis -= status.elapsedTimeNano) < 3000L) {
                            delayMillis = 3000L;
                        }
                        this.nodeCheckTimeoutMillis = delayMillis;
                    }
                    TimeUnit.MILLISECONDS.sleep(delayMillis);
                    continue;
                }
                if (this.getCurrentTimeNano() - this.contextLastUsedTimestampNano >= TimeUnit.MILLISECONDS.toNanos(this.monitorDisposalTimeMillis)) {
                    this.monitorService.notifyUnused(this);
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.stopped = true;
        }
    }

    ConnectionStatus checkConnectionStatus(long shortestFailureDetectionIntervalMillis) {
        long startNano = this.getCurrentTimeNano();
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                HashMap<String, String> monitoringConnProperties = new HashMap<String, String>();
                String defaultTimeout = Long.toString(shortestFailureDetectionIntervalMillis);
                monitoringConnProperties.put(PropertyKey.connectTimeout.getKeyName(), defaultTimeout);
                monitoringConnProperties.put(PropertyKey.socketTimeout.getKeyName(), defaultTimeout);
                Properties originalProperties = this.propertySet.exposeAsProperties();
                if (originalProperties != null) {
                    originalProperties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), originalProperties.getProperty((String)p)));
                }
                startNano = this.getCurrentTimeNano();
                this.monitoringConn = this.connectionProvider.connect(this.copy(this.hostInfo, monitoringConnProperties));
                return new ConnectionStatus(true, this.getCurrentTimeNano() - startNano);
            }
            startNano = this.getCurrentTimeNano();
            boolean isValid = this.monitoringConn.isValid((int)TimeUnit.MILLISECONDS.toSeconds(shortestFailureDetectionIntervalMillis));
            return new ConnectionStatus(isValid, this.getCurrentTimeNano() - startNano);
        }
        catch (SQLException sqlEx) {
            return new ConnectionStatus(false, this.getCurrentTimeNano() - startNano);
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    private HostInfo copy(HostInfo src, Map<String, String> props) {
        return new HostInfo(null, src.getHost(), src.getPort(), src.getUser(), src.getPassword(), props);
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTimeNano;

        ConnectionStatus(boolean isValid, long elapsedTimeNano) {
            this.isValid = isValid;
            this.elapsedTimeNano = elapsedTimeNano;
        }
    }
}

