/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;

public class ConnectionUtils {
    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, Map<String, String> additionalProps) {
        if (baseHostInfo == null || additionalProps == null) {
            return baseHostInfo;
        }
        ConnectionUrl urlContainer = ConnectionUrl.getConnectionUrlInstance(baseHostInfo.getDatabaseUrl(), new Properties());
        Map<String, String> originalProps = baseHostInfo.getHostProperties();
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        mergedProps.putAll(originalProps);
        mergedProps.putAll(additionalProps);
        return new HostInfo(urlContainer, baseHostInfo.getHost(), baseHostInfo.getPort(), baseHostInfo.getUser(), baseHostInfo.getPassword(), mergedProps);
    }

    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, ConnectionUrl connectionUrl) {
        if (connectionUrl == null) {
            return baseHostInfo;
        }
        HostInfo mainHost = connectionUrl.getMainHost();
        if (baseHostInfo == null) {
            return mainHost;
        }
        return ConnectionUtils.copyWithAdditionalProps(baseHostInfo, mainHost);
    }

    public static HostInfo copyWithAdditionalProps(HostInfo baseHostInfo, HostInfo newHostInfo) {
        ConnectionUrl urlContainer = ConnectionUrl.getConnectionUrlInstance(baseHostInfo.getDatabaseUrl(), new Properties());
        Map<String, String> originalProps = baseHostInfo.getHostProperties();
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        mergedProps.putAll(originalProps);
        mergedProps.putAll(newHostInfo.getHostProperties());
        return new HostInfo(urlContainer, baseHostInfo.getHost(), baseHostInfo.getPort(), newHostInfo.getUser(), newHostInfo.getPassword(), mergedProps);
    }

    public static HostInfo createHostWithProperties(HostInfo baseHost, Map<String, String> properties) throws SQLException {
        HashMap<String, String> propertiesCopy = new HashMap<String, String>(properties);
        propertiesCopy.putAll(baseHost.getHostProperties());
        String hostEndpoint = baseHost.getHost();
        int port = baseHost.getPort();
        String user = (String)propertiesCopy.get(PropertyKey.USER.getKeyName());
        String password = (String)propertiesCopy.get(PropertyKey.PASSWORD.getKeyName());
        propertiesCopy.remove(PropertyKey.USER.getKeyName());
        propertiesCopy.remove(PropertyKey.PASSWORD.getKeyName());
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)propertiesCopy);
        ConnectionUrl hostUrl = ConnectionUrl.getConnectionUrlInstance(ConnectionUtils.getUrlFromEndpoint(hostEndpoint, port, connProps), connProps);
        return new HostInfo(hostUrl, hostEndpoint, port, user, password, propertiesCopy);
    }

    public static String getUrlFromEndpoint(String endpoint, int port, Properties props) throws SQLException {
        Properties propsCopy = new Properties();
        propsCopy.putAll((Map<?, ?>)props);
        String portString = port < 1 ? "" : ":" + port;
        StringBuilder urlBuilder = new StringBuilder(String.format("%s//%s%s", ConnectionUrl.Type.SINGLE_CONNECTION_AWS.getScheme(), endpoint, portString));
        String dbName = propsCopy.getProperty(PropertyKey.DBNAME.getKeyName());
        if (!StringUtils.isNullOrEmpty(dbName)) {
            urlBuilder.append("/").append(dbName);
        }
        propsCopy.remove(PropertyKey.DBNAME.getKeyName());
        StringBuilder queryBuilder = new StringBuilder();
        if (propsCopy.size() != 0) {
            Enumeration<?> propertyNames = propsCopy.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement().toString();
                if (propertyName == null || propertyName.trim().equals("")) continue;
                if (queryBuilder.length() != 0) {
                    queryBuilder.append("&");
                }
                String propertyValue = propsCopy.getProperty(propertyName);
                try {
                    queryBuilder.append(propertyName).append("=").append(URLEncoder.encode(propertyValue, StandardCharsets.UTF_8.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(Messages.getString("ConnectionUtils.1"));
                }
            }
        }
        if (queryBuilder.length() != 0) {
            urlBuilder.append("?").append((CharSequence)queryBuilder);
        } else {
            urlBuilder.append("/");
        }
        return urlBuilder.toString();
    }

    public static boolean isNetworkException(SQLException exception) {
        String sqlState = exception.getSQLState();
        return ConnectionUtils.isNetworkException(sqlState);
    }

    public static boolean isNetworkException(String sqlState) {
        return sqlState != null && sqlState.startsWith("08");
    }
}

