/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.authentication;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.ExceptionFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.LogFactory;

public class AwsIamAuthenticationTokenHelper {
    private String token;
    private final Region region;
    private final String hostname;
    private final int port;
    private final Log log;
    private static final int REGION_MATCHER_GROUP = 3;

    public AwsIamAuthenticationTokenHelper(String hostname, int port, String logger) {
        this.log = LogFactory.getLogger(logger, "MySQL");
        this.hostname = hostname;
        this.port = port;
        this.region = this.getRdsRegion();
    }

    public String getOrGenerateToken(String user) {
        if (this.token == null) {
            this.token = this.generateAuthenticationToken(user);
        }
        return this.token;
    }

    private String generateAuthenticationToken(String user) {
        RdsUtilities utilities = RdsUtilities.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).region(this.region).build();
        return utilities.generateAuthenticationToken(builder -> builder.hostname(this.hostname).port(this.port).username(user));
    }

    private Region getRdsRegion() {
        Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?[a-zA-Z0-9]+\\.([a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com", 2);
        Matcher matcher = auroraDnsPattern.matcher(this.hostname);
        if (!matcher.find()) {
            String exceptionMessage = Messages.getString("AuthenticationAwsIamPlugin.UnsupportedHostname", new String[]{this.hostname});
            this.log.logTrace(exceptionMessage);
            throw ExceptionFactory.createException(exceptionMessage);
        }
        String rdsRegion = matcher.group(3);
        Optional<Region> regionOptional = Region.regions().stream().filter(r -> r.id().equalsIgnoreCase(rdsRegion)).findFirst();
        if (!regionOptional.isPresent()) {
            String exceptionMessage = Messages.getString("AuthenticationAwsIamPlugin.UnsupportedRegion", new String[]{this.hostname});
            this.log.logTrace(exceptionMessage);
            throw ExceptionFactory.createException(exceptionMessage);
        }
        return regionOptional.get();
    }
}

