/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class DefaultConnectionPlugin
implements IConnectionPlugin {
    protected Log logger;
    protected IConnectionProvider connectionProvider;
    protected final ICurrentConnectionProvider currentConnectionProvider;

    public DefaultConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, Log logger) {
        this(currentConnectionProvider, logger, new BasicConnectionProvider());
    }

    public DefaultConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, Log logger, IConnectionProvider connectionProvider) {
        if (logger == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("logger"));
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("connectionProvider"));
        }
        if (currentConnectionProvider == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("currentConnectionProvider"));
        }
        this.logger = logger;
        this.connectionProvider = connectionProvider;
        this.currentConnectionProvider = currentConnectionProvider;
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        try {
            return executeSqlFunc.call();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable targetException = invocationTargetException.getTargetException();
            this.logger.logTrace(String.format("[DefaultConnectionPlugin.execute]: method=%s.%s, exception: ", methodInvokeOn.getName(), methodName), targetException);
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw (Exception)targetException;
        }
        catch (Exception ex) {
            this.logger.logTrace(String.format("[DefaultConnectionPlugin.execute]: method=%s.%s, exception: ", methodInvokeOn.getName(), methodName), ex);
            throw ex;
        }
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        if (this.currentConnectionProvider.getCurrentConnection() != null) {
            return;
        }
        HostInfo mainHostInfo = connectionUrl.getMainHost();
        ConnectionImpl connection = this.connectionProvider.connect(mainHostInfo);
        this.currentConnectionProvider.setCurrentConnection(connection, mainHostInfo);
    }

    @Override
    public void transactionBegun() {
    }

    @Override
    public void transactionCompleted() {
    }

    @Override
    public void releaseResources() {
    }
}

