/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins;

import java.sql.SQLException;
import java.util.Set;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class MonitorConnectionContext {
    private final int failureDetectionIntervalMillis;
    private final int failureDetectionTimeMillis;
    private final int failureDetectionCount;
    private final Set<String> nodeKeys;
    private final Log log;
    private final JdbcConnection connectionToAbort;
    private long startMonitorTime;
    private long invalidNodeStartTime;
    private int failureCount;
    private boolean nodeUnhealthy;
    private boolean activeContext = true;

    public MonitorConnectionContext(JdbcConnection connectionToAbort, Set<String> nodeKeys, Log log, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        this.connectionToAbort = connectionToAbort;
        this.nodeKeys = nodeKeys;
        this.log = log;
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
    }

    void setStartMonitorTime(long startMonitorTime) {
        this.startMonitorTime = startMonitorTime;
    }

    Set<String> getNodeKeys() {
        return this.nodeKeys;
    }

    public int getFailureDetectionTimeMillis() {
        return this.failureDetectionTimeMillis;
    }

    public int getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public int getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTime(long invalidNodeStartTimeMillis) {
        this.invalidNodeStartTime = invalidNodeStartTimeMillis;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTime = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTime > 0L;
    }

    public long getInvalidNodeStartTime() {
        return this.invalidNodeStartTime;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy;
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy = nodeUnhealthy;
    }

    public boolean isActiveContext() {
        return this.activeContext;
    }

    public void invalidate() {
        this.activeContext = false;
    }

    synchronized void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext) {
            return;
        }
        try {
            this.connectionToAbort.abortInternal();
        }
        catch (SQLException sqlEx) {
            this.log.logTrace(String.format("Exception during aborting connection: %s", sqlEx.getMessage()));
        }
    }

    public void updateConnectionStatus(long currentTime, boolean isValid) {
        if (!this.activeContext) {
            return;
        }
        long totalElapsedTimeMillis = currentTime - this.startMonitorTime;
        if (totalElapsedTimeMillis > (long)this.failureDetectionTimeMillis) {
            this.setConnectionValid(isValid, currentTime);
        }
    }

    void setConnectionValid(boolean connectionValid, long currentTime) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationMillis;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTime(currentTime);
            }
            if ((invalidNodeDurationMillis = currentTime - this.getInvalidNodeStartTime()) >= (maxInvalidNodeDurationMillis = (long)this.getFailureDetectionIntervalMillis() * (long)this.getFailureDetectionCount())) {
                this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *dead*.", this.nodeKeys));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is not *responding* (%d).", this.nodeKeys, this.getFailureCount()));
            return;
        }
        this.setFailureCount(0);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *alive*.", this.nodeKeys));
    }
}

