/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareConnectionProxy;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.DefaultConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.IConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.NodeMonitoringConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ConnectionPluginManager {
    protected static final String DEFAULT_PLUGIN_FACTORIES = NodeMonitoringConnectionPluginFactory.class.getName();
    protected static final Queue<ConnectionPluginManager> instances = new ConcurrentLinkedQueue<ConnectionPluginManager>();
    protected Log logger;
    protected PropertySet propertySet = null;
    protected IConnectionPlugin headPlugin = null;
    ClusterAwareConnectionProxy proxy;

    public ConnectionPluginManager(Log logger) {
        if (logger == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("logger"));
        }
        this.logger = logger;
    }

    public void init(ClusterAwareConnectionProxy proxy, PropertySet propertySet) {
        instances.add(this);
        this.proxy = proxy;
        this.propertySet = propertySet;
        String factoryClazzNames = propertySet.getStringProperty(PropertyKey.connectionPluginFactories).getValue();
        if (StringUtils.isNullOrEmpty(factoryClazzNames)) {
            factoryClazzNames = DEFAULT_PLUGIN_FACTORIES;
        }
        this.headPlugin = new DefaultConnectionPluginFactory().getInstance(this.proxy, this.propertySet, null, this.logger);
        if (!StringUtils.isNullOrEmpty(factoryClazzNames)) {
            IConnectionPluginFactory[] factories = Util.loadClasses(factoryClazzNames, "MysqlIo.BadConnectionPluginFactory", null).toArray(new IConnectionPluginFactory[0]);
            for (int i = factories.length - 1; i >= 0; --i) {
                this.headPlugin = factories[i].getInstance(this.proxy, this.propertySet, this.headPlugin, this.logger);
            }
        }
    }

    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc) throws Exception {
        return this.headPlugin.execute(methodInvokeOn, methodName, executeSqlFunc);
    }

    public void releaseResources() {
        instances.remove(this);
        this.logger.logTrace("[ConnectionPluginManager.releaseResources]");
        this.headPlugin.releaseResources();
    }

    public static void releaseAllResources() {
        instances.forEach(ConnectionPluginManager::releaseResources);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ConnectionPluginManager::releaseAllResources));
    }
}

