/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca;

import java.io.EOFException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.NativeSession;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrlParser;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcPropertySetImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.CommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.SQLError;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.AuroraTopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.CanCollectPerformanceMetrics;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareConnectionLifecycleInterceptor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareMetrics;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareWriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.ConnectionPluginManager;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.interceptors.ConnectionLifecycleInterceptor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.interceptors.ConnectionLifecycleInterceptorProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.LogFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.IpAddressUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ClusterAwareConnectionProxy
extends MultiHostConnectionProxy
implements ConnectionLifecycleInterceptorProvider,
ICurrentConnectionProvider {
    static final String METHOD_SET_READ_ONLY = "setReadOnly";
    static final String METHOD_SET_AUTO_COMMIT = "setAutoCommit";
    static final String METHOD_COMMIT = "commit";
    static final String METHOD_ROLLBACK = "rollback";
    static final String METHOD_CLOSE = "close";
    static final String METHOD_EQUALS = "equals";
    private final Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraCustomClusterPattern = Pattern.compile("(.+)\\.(cluster-custom-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraProxyDnsPattern = Pattern.compile("(.+)\\.(proxy-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected static final int NO_CONNECTION_INDEX = -1;
    protected static final int WRITER_CONNECTION_INDEX = 0;
    protected int currentHostIndex = -1;
    protected Map<String, String> initialConnectionProps;
    protected Boolean explicitlyReadOnly = null;
    protected boolean inTransaction = false;
    protected boolean explicitlyAutoCommit = true;
    protected boolean isClusterTopologyAvailable = false;
    protected boolean isMultiWriterCluster = false;
    protected boolean isRdsProxy = false;
    protected boolean isRds = false;
    protected TopologyService topologyService;
    protected List<HostInfo> hosts = new ArrayList<HostInfo>();
    protected WriterFailoverHandler writerFailoverHandler;
    protected ReaderFailoverHandler readerFailoverHandler;
    protected ConnectionProvider connectionProvider;
    protected ConnectionPluginManager pluginManager = null;
    protected ClusterAwareMetrics metrics = new ClusterAwareMetrics();
    private long invokeStartTimeMs;
    private long failoverStartTimeMs;
    protected boolean enableFailoverSetting = true;
    protected int clusterTopologyRefreshRateMsSetting;
    protected boolean gatherPerfMetricsSetting;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected String clusterIdSetting;
    protected String clusterInstanceHostPatternSetting;
    protected int failoverConnectTimeoutMs;
    protected int failoverSocketTimeoutMs;
    private HostInfo mainHost = null;

    public static JdbcConnection autodetectClusterAndCreateProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        ClusterAwareConnectionProxy connProxy = new ClusterAwareConnectionProxy(connectionUrl);
        if (connProxy.isFailoverEnabled()) {
            return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
        }
        connProxy.currentConnection.setProxy(null);
        return connProxy.currentConnection;
    }

    public boolean isFailoverEnabled() {
        return this.enableFailoverSetting && !this.isRdsProxy && this.isClusterTopologyAvailable && !this.isMultiWriterCluster && (this.hosts == null || this.hosts.size() > 1);
    }

    public static JdbcConnection createProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        ClusterAwareConnectionProxy connProxy = new ClusterAwareConnectionProxy(connectionUrl);
        return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
    }

    public ClusterAwareConnectionProxy(ConnectionUrl connectionUrl) throws SQLException {
        super(connectionUrl);
        this.initialConnectionProps = connectionUrl.getMainHost().getHostProperties();
        this.initSettings(connectionUrl);
        this.initLogger(connectionUrl);
        AuroraTopologyService topologyService = new AuroraTopologyService(this.log);
        topologyService.setPerformanceMetricsEnabled(this.gatherPerfMetricsSetting);
        topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        this.topologyService = topologyService;
        this.connectionProvider = new BasicConnectionProvider();
        this.readerFailoverHandler = new ClusterAwareReaderFailoverHandler(this.topologyService, this.connectionProvider, this.initialConnectionProps, this.failoverTimeoutMsSetting, this.failoverReaderConnectTimeoutMsSetting, this.log);
        this.writerFailoverHandler = new ClusterAwareWriterFailoverHandler(this.topologyService, this.connectionProvider, this.readerFailoverHandler, this.initialConnectionProps, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting, this.log);
        this.initProxy(connectionUrl);
    }

    ClusterAwareConnectionProxy(ConnectionUrl connectionUrl, ConnectionProvider connectionProvider, TopologyService service, WriterFailoverHandler writerFailoverHandler, ReaderFailoverHandler readerFailoverHandler, Function<Log, ConnectionPluginManager> connectionPluginManagerInitializer) throws SQLException {
        super(connectionUrl);
        this.initialConnectionProps = connectionUrl.getMainHost().getHostProperties();
        this.initSettings(connectionUrl);
        this.initLogger(connectionUrl);
        this.topologyService = service;
        this.topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        if (this.topologyService instanceof CanCollectPerformanceMetrics) {
            ((CanCollectPerformanceMetrics)((Object)this.topologyService)).setPerformanceMetricsEnabled(this.gatherPerfMetricsSetting);
        }
        this.connectionProvider = connectionProvider;
        this.writerFailoverHandler = writerFailoverHandler;
        this.readerFailoverHandler = readerFailoverHandler;
        this.initProxy(connectionUrl, connectionPluginManagerInitializer);
    }

    protected void initSettings(ConnectionUrl connectionUrl) throws SQLException {
        JdbcPropertySetImpl connProps = new JdbcPropertySetImpl();
        try {
            connProps.initializeProperties(connectionUrl.getMainHost().exposeAsProperties());
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, null);
        }
        this.enableFailoverSetting = connProps.getBooleanProperty(PropertyKey.enableClusterAwareFailover).getValue();
        this.clusterTopologyRefreshRateMsSetting = connProps.getIntegerProperty(PropertyKey.clusterTopologyRefreshRateMs).getValue();
        this.gatherPerfMetricsSetting = connProps.getBooleanProperty(PropertyKey.gatherPerfMetrics).getValue();
        this.failoverTimeoutMsSetting = connProps.getIntegerProperty(PropertyKey.failoverTimeoutMs).getValue();
        this.failoverClusterTopologyRefreshRateMsSetting = connProps.getIntegerProperty(PropertyKey.failoverClusterTopologyRefreshRateMs).getValue();
        this.failoverWriterReconnectIntervalMsSetting = connProps.getIntegerProperty(PropertyKey.failoverWriterReconnectIntervalMs).getValue();
        this.failoverReaderConnectTimeoutMsSetting = connProps.getIntegerProperty(PropertyKey.failoverReaderConnectTimeoutMs).getValue();
        this.clusterIdSetting = connProps.getStringProperty(PropertyKey.clusterId).getValue();
        this.clusterInstanceHostPatternSetting = connProps.getStringProperty(PropertyKey.clusterInstanceHostPattern).getValue();
        this.failoverConnectTimeoutMs = connProps.getIntegerProperty(PropertyKey.connectTimeout).getValue();
        this.failoverSocketTimeoutMs = connProps.getIntegerProperty(PropertyKey.socketTimeout).getValue();
    }

    protected void initLogger(ConnectionUrl connUrl) {
        String loggerClassName = connUrl.getOriginalProperties().get(PropertyKey.logger.getKeyName());
        if (!StringUtils.isNullOrEmpty(loggerClassName)) {
            this.log = LogFactory.getLogger(loggerClassName, "MySQL");
        }
    }

    protected void initProxy(ConnectionUrl connUrl) throws SQLException {
        this.initProxy(connUrl, ConnectionPluginManager::new);
    }

    private void initProxy(ConnectionUrl connUrl, Function<Log, ConnectionPluginManager> connectionPluginManagerInitializer) throws SQLException {
        if (!this.enableFailoverSetting) {
            this.currentConnection = this.connectionProvider.connect(connUrl.getMainHost());
            return;
        }
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.8"));
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.9", new Object[]{"clusterId", this.clusterIdSetting}));
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.9", new Object[]{"clusterInstanceHostPattern", this.clusterInstanceHostPatternSetting}));
        this.mainHost = this.connectionUrl.getMainHost();
        if (!StringUtils.isNullOrEmpty(this.clusterInstanceHostPatternSetting)) {
            this.initFromHostPatternSetting(connUrl, this.mainHost);
        } else if (IpAddressUtils.isIPv4(this.mainHost.getHost()) || IpAddressUtils.isIPv6(this.mainHost.getHost())) {
            this.initExpectingNoTopology(connUrl, this.mainHost);
        } else {
            this.identifyRdsType(this.mainHost.getHost());
            if (!this.isRds) {
                this.initExpectingNoTopology(connUrl, this.mainHost);
            } else {
                this.initFromConnectionString(connUrl, this.mainHost);
            }
        }
        if (this.pluginManager == null) {
            this.pluginManager = connectionPluginManagerInitializer.apply(this.log);
            this.pluginManager.init(this, this.currentConnection.getPropertySet());
        }
    }

    private void initFromHostPatternSetting(ConnectionUrl connUrl, HostInfo mainHost) throws SQLException {
        ConnectionUrlParser.Pair<String, Integer> pair = this.getHostPortPairFromHostPatternSetting();
        String instanceHostPattern = (String)pair.left;
        int instanceHostPort = (Integer)pair.right != -1 ? ((Integer)pair.right).intValue() : mainHost.getPort();
        this.setClusterId(instanceHostPattern, instanceHostPort);
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(mainHost, instanceHostPattern, instanceHostPort));
        this.createConnectionAndInitializeTopology(connUrl);
    }

    private ConnectionUrlParser.Pair<String, Integer> getHostPortPairFromHostPatternSetting() throws SQLException {
        ConnectionUrlParser.Pair<String, Integer> pair = ConnectionUrlParser.parseHostPortPair(this.clusterInstanceHostPatternSetting);
        if (pair == null) {
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.5"));
        }
        this.validateHostPatternSetting((String)pair.left);
        return pair;
    }

    private void validateHostPatternSetting(String hostPattern) throws SQLException {
        if (!this.isDnsPatternValid(hostPattern)) {
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.21"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.21"));
        }
        this.identifyRdsType(hostPattern);
        if (this.isRdsProxy) {
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.7"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.7"));
        }
        if (this.isRdsCustomClusterDns(hostPattern)) {
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.18"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.18"));
        }
    }

    private boolean isDnsPatternValid(String pattern) {
        return pattern.contains("?");
    }

    private void identifyRdsType(String host) {
        this.isRds = this.isRdsDns(host);
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isRds", this.isRds}));
        this.isRdsProxy = this.isRdsProxyDns(host);
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isRdsProxy", this.isRdsProxy}));
    }

    private void initExpectingNoTopology(ConnectionUrl connUrl, HostInfo mainHost) throws SQLException {
        this.setClusterId(mainHost.getHost(), mainHost.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(mainHost, mainHost.getHost(), mainHost.getPort()));
        this.createConnectionAndInitializeTopology(connUrl);
        if (this.isClusterTopologyAvailable) {
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.6"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.6"));
        }
    }

    private void initFromConnectionString(ConnectionUrl connUrl, HostInfo mainHost) throws SQLException {
        String rdsInstanceHostPattern = this.getRdsInstanceHostPattern(mainHost.getHost());
        if (rdsInstanceHostPattern == null) {
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.20"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.20"));
        }
        this.setClusterId(mainHost.getHost(), mainHost.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(mainHost, rdsInstanceHostPattern, mainHost.getPort()));
        this.createConnectionAndInitializeTopology(connUrl);
    }

    private void setClusterId(String host, int port) {
        String clusterRdsHostUrl;
        if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
            this.topologyService.setClusterId(this.clusterIdSetting);
        } else if (this.isRdsProxy) {
            this.topologyService.setClusterId(host + ":" + port);
        } else if (this.isRds && !StringUtils.isNullOrEmpty(clusterRdsHostUrl = this.getRdsClusterHostUrl(host))) {
            this.topologyService.setClusterId(clusterRdsHostUrl + ":" + port);
        }
    }

    private HostInfo createClusterInstanceTemplate(HostInfo mainHost, String host, int port) {
        HashMap<String, String> properties = new HashMap<String, String>(this.initialConnectionProps);
        properties.put(PropertyKey.connectTimeout.getKeyName(), String.valueOf(this.failoverConnectTimeoutMs));
        properties.put(PropertyKey.socketTimeout.getKeyName(), String.valueOf(this.failoverSocketTimeoutMs));
        return new HostInfo(this.connectionUrl, host, port, mainHost.getUser(), mainHost.getPassword(), mainHost.isPasswordless(), properties);
    }

    protected void createConnectionAndInitializeTopology(ConnectionUrl connUrl) throws SQLException {
        this.createInitialConnection(connUrl);
        this.initTopology();
        if (this.isFailoverEnabled()) {
            this.validateInitialConnection();
            if (this.currentHostIndex != -1 && !Util.isNullOrEmpty(this.hosts)) {
                HostInfo currentHost = this.hosts.get(this.currentHostIndex);
                if (this.isExplicitlyReadOnly()) {
                    this.topologyService.setLastUsedReaderHost(currentHost);
                }
            }
            this.currentConnection.getPropertySet().getIntegerProperty(PropertyKey.socketTimeout).setValue(this.failoverSocketTimeoutMs);
            ((NativeSession)this.currentConnection.getSession()).setSocketTimeout(this.failoverSocketTimeoutMs);
        }
    }

    private boolean isExplicitlyReadOnly() {
        return this.explicitlyReadOnly != null && this.explicitlyReadOnly != false;
    }

    private void createInitialConnection(ConnectionUrl connUrl) throws SQLException {
        String host = connUrl.getMainHost().getHost();
        if (this.isRdsClusterDns(host)) {
            this.explicitlyReadOnly = this.isReaderClusterDns(host);
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            try {
                this.attemptConnectionUsingCachedTopology();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!this.isConnected()) {
            this.currentConnection = this.connectionProvider.connect(connUrl.getMainHost());
            this.setConnectionProxy(this.currentConnection);
        }
    }

    boolean isConnected() {
        return this.currentHostIndex != -1;
    }

    protected void setConnectionProxy(JdbcConnection conn) {
        JdbcConnection topmostProxy = this.getProxy();
        if (topmostProxy != this.thisAsConnection) {
            conn.setProxy(this.thisAsConnection);
        }
        conn.setProxy(topmostProxy);
    }

    private void attemptConnectionUsingCachedTopology() throws SQLException {
        int candidateIndex;
        List<HostInfo> cachedHosts = this.topologyService.getCachedTopology();
        if (Util.isNullOrEmpty(cachedHosts)) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerUseCachedTopology(false);
            }
            return;
        }
        this.hosts = cachedHosts;
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerUseCachedTopology(true);
        }
        if ((candidateIndex = this.getCandidateIndexForInitialConnection()) != -1) {
            this.connectTo(candidateIndex);
        }
    }

    private int getCandidateIndexForInitialConnection() {
        int candidateReaderIndex;
        if (Util.isNullOrEmpty(this.hosts)) {
            return -1;
        }
        if (this.isExplicitlyReadOnly() && (candidateReaderIndex = this.getCandidateReaderForInitialConnection()) != -1) {
            return candidateReaderIndex;
        }
        return 0;
    }

    private int getCandidateReaderForInitialConnection() {
        int lastUsedReaderIndex = this.getHostIndex(this.topologyService.getLastUsedReaderHost());
        if (lastUsedReaderIndex != -1) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerUseLastConnectedReader(true);
            }
            return lastUsedReaderIndex;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerUseLastConnectedReader(false);
        }
        if (this.clusterContainsReader()) {
            return this.getRandomReaderIndex();
        }
        return -1;
    }

    private boolean clusterContainsReader() {
        return this.hosts.size() > 1;
    }

    private int getRandomReaderIndex() {
        int max = this.hosts.size() - 1;
        int min = 1;
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    private void initTopology() {
        List<HostInfo> topology;
        if (this.currentConnection != null && !Util.isNullOrEmpty(topology = this.topologyService.getTopology(this.currentConnection, false))) {
            this.hosts = topology;
        }
        this.isClusterTopologyAvailable = !Util.isNullOrEmpty(this.hosts);
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isClusterTopologyAvailable", this.isClusterTopologyAvailable}));
        this.isMultiWriterCluster = this.topologyService.isMultiWriterCluster();
        if (this.isFailoverEnabled()) {
            this.logTopology();
        }
    }

    private void validateInitialConnection() throws SQLException {
        this.currentHostIndex = this.getHostIndex(this.topologyService.getHostByName(this.currentConnection));
        if (!this.isConnected()) {
            this.pickNewConnection();
            return;
        }
        if (this.validWriterConnection()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerInvalidInitialConnection(false);
            }
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerInvalidInitialConnection(true);
        }
        try {
            this.connectTo(0);
        }
        catch (SQLException e) {
            if (this.gatherPerfMetricsSetting) {
                this.failoverStartTimeMs = System.currentTimeMillis();
            }
            this.failover(0);
        }
    }

    private int getHostIndex(HostInfo host) {
        if (host == null || Util.isNullOrEmpty(this.hosts)) {
            return -1;
        }
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo potentialMatch = this.hosts.get(i);
            if (potentialMatch == null || !potentialMatch.equalHostPortPair(host)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.1"));
            return;
        }
        if (this.isConnected() || Util.isNullOrEmpty(this.hosts)) {
            this.failover(this.currentHostIndex);
            return;
        }
        if (this.shouldAttemptReaderConnection()) {
            this.failoverReader(-1);
            return;
        }
        try {
            this.connectTo(0);
            if (this.isExplicitlyReadOnly() && this.currentHostIndex != -1) {
                this.topologyService.setLastUsedReaderHost(this.hosts.get(this.currentHostIndex));
            }
        }
        catch (SQLException e) {
            this.failover(0);
        }
    }

    @Override
    public JdbcConnection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public HostInfo getCurrentHostInfo() {
        return this.currentHostIndex != -1 ? this.hosts.get(this.currentHostIndex) : this.mainHost;
    }

    private boolean shouldAttemptReaderConnection() {
        return this.isExplicitlyReadOnly() && this.clusterContainsReader();
    }

    private void connectTo(int hostIndex) throws SQLException {
        try {
            this.switchCurrentConnectionTo(hostIndex, this.createConnectionForHostIndex(hostIndex));
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{this.hosts.get(hostIndex)}));
        }
        catch (SQLException e) {
            if (this.currentConnection != null) {
                HostInfo host = this.hosts.get(hostIndex);
                StringBuilder msg = new StringBuilder("Connection to ").append(this.isWriterHostIndex(hostIndex) ? "writer" : "reader").append(" host '").append(host == null ? "<null>" : host.getHostPortPair()).append("' failed");
                try {
                    this.log.logWarn(msg.toString(), e);
                }
                catch (CJException ex) {
                    throw SQLExceptionsMapping.translateException(e, this.currentConnection.getExceptionInterceptor());
                }
            }
            throw e;
        }
    }

    private boolean isWriterHostIndex(int hostIndex) {
        return hostIndex == 0;
    }

    private void switchCurrentConnectionTo(int hostIndex, JdbcConnection connection) throws SQLException {
        this.invalidateCurrentConnection();
        boolean readOnly = this.isWriterHostIndex(hostIndex) ? this.isExplicitlyReadOnly() : (this.explicitlyReadOnly != null ? this.explicitlyReadOnly : (this.currentConnection != null ? this.currentConnection.isReadOnly() : false));
        this.syncSessionState(this.currentConnection, connection, readOnly);
        this.currentConnection = connection;
        this.currentHostIndex = hostIndex;
        this.inTransaction = false;
    }

    private ConnectionImpl createConnectionForHostIndex(int hostIndex) throws SQLException {
        return this.createConnectionForHost(this.hosts.get(hostIndex));
    }

    @Override
    protected ConnectionImpl createConnectionForHost(HostInfo baseHostInfo) throws SQLException {
        HostInfo hostInfoWithInitialProps = ClusterAwareUtils.copyWithAdditionalProps(baseHostInfo, this.connectionUrl);
        ConnectionImpl conn = this.connectionProvider.connect(hostInfoWithInitialProps);
        this.setConnectionProxy(conn);
        return conn;
    }

    private boolean validWriterConnection() {
        return this.explicitlyReadOnly == null || this.explicitlyReadOnly != false || this.isWriterHostIndex(this.currentHostIndex);
    }

    protected synchronized void failover(int failedHostIdx) throws SQLException {
        if (this.shouldPerformWriterFailover()) {
            this.failoverWriter();
        } else {
            this.failoverReader(failedHostIdx);
        }
        if (this.inTransaction) {
            this.inTransaction = false;
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.1"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.1"), "08007");
        }
        this.log.logError(Messages.getString("ClusterAwareConnectionProxy.3"));
        throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.3"), "08S02");
    }

    private boolean shouldPerformWriterFailover() {
        return this.explicitlyReadOnly == null || this.explicitlyReadOnly == false;
    }

    protected void failoverWriter() throws SQLException {
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.16"));
        WriterFailoverResult failoverResult = this.writerFailoverHandler.failover(this.hosts);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerWriterFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (failoverResult == null || !failoverResult.isConnected()) {
            this.processFailoverFailure(Messages.getString("ClusterAwareConnectionProxy.2"));
            return;
        }
        if (!Util.isNullOrEmpty(failoverResult.getTopology())) {
            this.hosts = failoverResult.getTopology();
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(true);
        }
        this.currentHostIndex = 0;
        this.currentConnection = failoverResult.getNewConnection();
        this.setConnectionProxy(this.currentConnection);
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{this.hosts.get(this.currentHostIndex)}));
    }

    private void processFailoverFailure(String message) throws SQLException {
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(false);
        }
        this.log.logError(message);
        throw new SQLException(message, "08001");
    }

    protected void failoverReader(int failedHostIdx) throws SQLException {
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.17"));
        HostInfo failedHost = null;
        if (failedHostIdx != -1 && !Util.isNullOrEmpty(this.hosts)) {
            failedHost = this.hosts.get(failedHostIdx);
        }
        ReaderFailoverResult result = this.readerFailoverHandler.failover(this.hosts, failedHost);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerReaderFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (result == null || !result.isConnected()) {
            this.processFailoverFailure(Messages.getString("ClusterAwareConnectionProxy.4"));
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(true);
        }
        this.currentConnection = result.getConnection();
        this.setConnectionProxy(this.currentConnection);
        this.currentHostIndex = result.getConnectionIndex();
        this.updateTopologyAndConnectIfNeeded(true);
        if (this.currentHostIndex != -1 && !Util.isNullOrEmpty(this.hosts)) {
            HostInfo currentHost = this.hosts.get(this.currentHostIndex);
            this.topologyService.setLastUsedReaderHost(currentHost);
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{currentHost}));
        }
    }

    protected void updateTopologyAndConnectIfNeeded(boolean forceUpdate) throws SQLException {
        if (!this.isFailoverEnabled() || this.currentConnection == null || this.currentConnection.isClosed()) {
            return;
        }
        List<HostInfo> latestTopology = this.topologyService.getTopology(this.currentConnection, forceUpdate);
        if (Util.isNullOrEmpty(latestTopology)) {
            return;
        }
        this.hosts = latestTopology;
        if (!this.isConnected()) {
            this.pickNewConnection();
            return;
        }
        this.updateHostIndex(latestTopology);
    }

    private void updateHostIndex(List<HostInfo> latestTopology) throws SQLException {
        HostInfo currentHost = this.hosts.get(this.currentHostIndex);
        int latestHostIndex = -1;
        for (int i = 0; i < latestTopology.size(); ++i) {
            HostInfo host = latestTopology.get(i);
            if (host == null || currentHost == null || !host.equalHostPortPair(currentHost)) continue;
            latestHostIndex = i;
            break;
        }
        if (latestHostIndex == -1) {
            this.currentHostIndex = -1;
            this.pickNewConnection();
        } else {
            this.currentHostIndex = latestHostIndex;
        }
    }

    public boolean isRds() {
        return this.isRds;
    }

    public boolean isRdsProxy() {
        return this.isRdsProxy;
    }

    private boolean isRdsDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return matcher.find();
    }

    private boolean isRdsProxyDns(String host) {
        Matcher matcher = this.auroraProxyDnsPattern.matcher(host);
        return matcher.find();
    }

    private String getRdsInstanceHostPattern(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        if (matcher.find()) {
            return "?." + matcher.group(3);
        }
        return null;
    }

    private String getRdsClusterHostUrl(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        if ("cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword)) {
            return matcher.group(1) + ".cluster-" + matcher.group(3);
        }
        return null;
    }

    private boolean isRdsClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        return "cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword);
    }

    private boolean isReaderClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return "cluster-ro-".equalsIgnoreCase(this.getClusterKeyword(matcher));
    }

    private boolean isRdsCustomClusterDns(String host) {
        Matcher matcher = this.auroraCustomClusterPattern.matcher(host);
        return matcher.find();
    }

    private String getClusterKeyword(Matcher matcher) {
        if (matcher.find() && matcher.group(2) != null && matcher.group(1) != null && !matcher.group(1).isEmpty()) {
            return matcher.group(2);
        }
        return null;
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.invokeStartTimeMs = this.gatherPerfMetricsSetting ? System.currentTimeMillis() : 0L;
        Object result = super.invoke(proxy, method, args);
        if (METHOD_CLOSE.equals(method.getName()) && this.gatherPerfMetricsSetting) {
            this.metrics.reportMetrics(this.log);
            if (this.topologyService instanceof CanCollectPerformanceMetrics) {
                ((CanCollectPerformanceMetrics)((Object)this.topologyService)).reportMetrics(this.log);
            }
        }
        return result;
    }

    @Override
    protected synchronized Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        this.updateTopologyAndConnectIfNeeded(false);
        if (this.isClosed && !this.allowedOnClosedConnection(method)) {
            this.invalidInvocationOnClosedConnection();
        }
        Object result = null;
        try {
            result = this.pluginManager.execute(this.thisAsConnection.getClass(), methodName, () -> method.invoke((Object)this.thisAsConnection, args));
            result = this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
        }
        catch (InvocationTargetException e) {
            this.dealWithInvocationException(e);
        }
        catch (IllegalStateException e) {
            this.dealWithIllegalStateException(e);
        }
        catch (Exception e) {
            this.dealWithOriginalException(e, null);
        }
        this.performSpecialMethodHandlingIfRequired(args, methodName);
        return result;
    }

    private void invalidInvocationOnClosedConnection() throws SQLException {
        if (this.autoReconnect && !this.closedExplicitly) {
            this.currentHostIndex = -1;
            this.isClosed = false;
            this.closedReason = null;
            this.pickNewConnection();
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.19"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.19"), "08S02");
        }
        String reason = "No operations allowed after connection closed.";
        if (this.closedReason != null) {
            reason = reason + " " + this.closedReason;
        }
        this.releasePluginManager();
        throw SQLError.createSQLException(reason, "08003", null);
    }

    @Override
    protected void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        this.dealWithOriginalException(e.getTargetException(), e);
    }

    protected void dealWithIllegalStateException(IllegalStateException e) throws Throwable {
        this.dealWithOriginalException(e.getCause(), e);
    }

    private void dealWithOriginalException(Throwable originalException, Exception wrapperException) throws Throwable {
        if (originalException != null) {
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12"), originalException);
            if (this.lastExceptionDealtWith != originalException && this.shouldExceptionTriggerConnectionSwitch(originalException)) {
                if (this.gatherPerfMetricsSetting) {
                    long currentTimeMs = System.currentTimeMillis();
                    this.metrics.registerFailureDetectionTime(currentTimeMs - this.invokeStartTimeMs);
                    this.invokeStartTimeMs = 0L;
                    this.failoverStartTimeMs = currentTimeMs;
                }
                this.invalidateCurrentConnection();
                this.pickNewConnection();
                this.lastExceptionDealtWith = originalException;
            }
            throw originalException;
        }
        throw wrapperException;
    }

    @Override
    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (!this.isFailoverEnabled()) {
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.13"));
            return false;
        }
        String sqlState = null;
        if (t instanceof CommunicationsException || t instanceof CJCommunicationsException) {
            return true;
        }
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        } else if (t instanceof CJException) {
            if (t.getCause() instanceof EOFException) {
                return true;
            }
            if (t.getCause() instanceof SSLException) {
                return true;
            }
            sqlState = ((CJException)t).getSQLState();
        }
        if (sqlState != null) {
            return sqlState.startsWith("08");
        }
        return false;
    }

    @Override
    protected void invalidateCurrentConnection() throws SQLException {
        if (this.inTransaction) {
            try {
                this.currentConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.invalidateConnection(this.currentConnection);
    }

    private void performSpecialMethodHandlingIfRequired(Object[] args, String methodName) throws SQLException {
        if (METHOD_SET_AUTO_COMMIT.equals(methodName)) {
            this.explicitlyAutoCommit = (Boolean)args[0];
            boolean bl = this.inTransaction = !this.explicitlyAutoCommit;
        }
        if (METHOD_COMMIT.equals(methodName) || METHOD_ROLLBACK.equals(methodName)) {
            this.inTransaction = false;
        }
        if (METHOD_SET_READ_ONLY.equals(methodName)) {
            this.explicitlyReadOnly = (Boolean)args[0];
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            this.connectToWriterIfRequired(this.explicitlyReadOnly);
        }
    }

    private void connectToWriterIfRequired(Boolean readOnly) throws SQLException {
        if (this.shouldReconnectToWriter(readOnly) && !Util.isNullOrEmpty(this.hosts)) {
            try {
                this.connectTo(0);
            }
            catch (SQLException e) {
                this.failover(0);
            }
        }
    }

    private boolean shouldReconnectToWriter(Boolean readOnly) {
        return readOnly != null && readOnly == false && !this.isWriterHostIndex(this.currentHostIndex);
    }

    @Override
    protected synchronized void doClose() throws SQLException {
        try {
            this.pluginManager.execute(this.getClass(), METHOD_CLOSE, () -> {
                this.currentConnection.close();
                return null;
            });
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
        this.releasePluginManager();
    }

    @Override
    protected synchronized void doAbort(Executor executor) throws SQLException {
        try {
            this.pluginManager.execute(this.getClass(), "abort", () -> {
                this.currentConnection.abort(executor);
                return null;
            });
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
        this.releasePluginManager();
    }

    @Override
    protected synchronized void doAbortInternal() throws SQLException {
        try {
            this.pluginManager.execute(this.getClass(), "abortInternal", () -> {
                this.currentConnection.abortInternal();
                return null;
            });
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
        this.releasePluginManager();
    }

    @Override
    protected InvocationHandler getNewJdbcInterfaceProxy(Object toProxy) {
        return new JdbcInterfaceProxy(toProxy);
    }

    @Override
    protected boolean isSourceConnection() {
        return this.isWriterHostIndex(this.currentHostIndex);
    }

    @Override
    public ConnectionLifecycleInterceptor getConnectionLifecycleInterceptor() {
        return new ClusterAwareConnectionLifecycleInterceptor(this);
    }

    protected boolean isCurrentConnectionReadOnly() {
        return this.isConnected() && !this.isWriterHostIndex(this.currentHostIndex);
    }

    protected boolean isCurrentConnectionWriter() {
        return this.isWriterHostIndex(this.currentHostIndex);
    }

    protected JdbcConnection getConnection() {
        return this.currentConnection;
    }

    public boolean isClusterTopologyAvailable() {
        return this.isClusterTopologyAvailable;
    }

    public boolean isMultiWriterCluster() {
        return this.isMultiWriterCluster;
    }

    private void logTopology() {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo hostInfo = this.hosts.get(i);
            msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
        }
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{msg.toString()}));
    }

    private void releasePluginManager() {
        if (this.pluginManager != null) {
            this.pluginManager.releaseResources();
            this.pluginManager = null;
        }
    }

    class JdbcInterfaceProxy
    implements InvocationHandler {
        Object invokeOn;

        JdbcInterfaceProxy(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ClusterAwareConnectionProxy.METHOD_EQUALS.equals(method.getName())) {
                return args[0].equals(this);
            }
            Object result = null;
            try {
                result = ClusterAwareConnectionProxy.this.pluginManager.execute(this.invokeOn.getClass(), method.getName(), () -> method.invoke(this.invokeOn, args));
                result = ClusterAwareConnectionProxy.this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
            }
            catch (InvocationTargetException e) {
                ClusterAwareConnectionProxy.this.dealWithInvocationException(e);
            }
            catch (IllegalStateException e) {
                ClusterAwareConnectionProxy.this.dealWithIllegalStateException(e);
            }
            catch (Exception e) {
                ClusterAwareConnectionProxy.this.dealWithOriginalException(e, null);
            }
            return result;
        }
    }
}

