/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.MysqlxSession;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.ExceptionFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.WrongArgumentException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ColumnDefinition;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ProtocolEntity;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ResultBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.FetchDoneEntity;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.Notice;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.StatementExecuteOk;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.BufferedRowList;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.DefaultColumnDefinition;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.Field;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.Row;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.RowResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.RowResultImpl;

public class RowResultBuilder
implements ResultBuilder<RowResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private RowResult result;
    TimeZone defaultTimeZone;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public RowResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public RowResult build() {
        if (this.metadata == null) {
            this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
        }
        this.result = new RowResultImpl(this.metadata, this.defaultTimeZone, new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

