/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.protocol.x;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import software.aws.rds.jdbc.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.shading.com.mysql.cj.exceptions.ExceptionFactory;
import software.aws.rds.jdbc.shading.com.mysql.cj.exceptions.WrongArgumentException;
import software.aws.rds.jdbc.shading.com.mysql.cj.protocol.x.CompressionMode;
import software.aws.rds.jdbc.shading.com.mysql.cj.protocol.x.SyncFlushDeflaterOutputStream;

public class CompressionAlgorithm {
    private String algorithmName;
    private CompressionMode compressionMode;
    private Class<?> inputStreamClass;
    private Class<?> outputStreamClass;

    public static Map<String, CompressionAlgorithm> getDefaultInstances() {
        HashMap<String, CompressionAlgorithm> defaultInstances = new HashMap<String, CompressionAlgorithm>();
        defaultInstances.put("deflate_stream", new CompressionAlgorithm("deflate_stream", InflaterInputStream.class, SyncFlushDeflaterOutputStream.class));
        return defaultInstances;
    }

    public CompressionAlgorithm(String name, Class<?> inputStreamClass, Class<?> outputStreamClass) {
        this.algorithmName = name.toLowerCase();
        String[] nameMode = name.split("_");
        if (nameMode.length != 2) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Protocol.Compression.6", new Object[]{name}));
        }
        try {
            CompressionMode mode;
            this.compressionMode = mode = CompressionMode.valueOf(nameMode[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Protocol.Compression.7", new Object[]{nameMode[1]}));
        }
        this.inputStreamClass = inputStreamClass;
        this.outputStreamClass = outputStreamClass;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public Class<?> getInputStreamClass() {
        return this.inputStreamClass;
    }

    public Class<?> getOutputStreamClass() {
        return this.outputStreamClass;
    }
}

