/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.aws.rds.jdbc.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionAttemptResult;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ResolvedHostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.NullLogger;

public class ClusterAwareWriterFailoverHandler
implements WriterFailoverHandler {
    static final int WRITER_CONNECTION_INDEX = 0;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;
    protected TopologyService topologyService;
    protected ConnectionProvider connectionProvider;
    protected ReaderFailoverHandler readerFailoverHandler;

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, ReaderFailoverHandler readerFailoverHandler, Log log) {
        this.topologyService = topologyService;
        this.connectionProvider = connectionProvider;
        this.readerFailoverHandler = readerFailoverHandler;
        if (log != null) {
            this.log = log;
        }
    }

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, ReaderFailoverHandler readerFailoverHandler, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs, Log log) {
        this(topologyService, connectionProvider, readerFailoverHandler, log);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResolvedHostInfo failover(List<HostInfo> currentTopology) throws SQLException {
        ExecutorService executorService = null;
        try {
            boolean isLatchZero;
            executorService = Executors.newFixedThreadPool(2);
            CountDownLatch taskCompletedLatch = new CountDownLatch(1);
            ReconnectToWriterHandler taskA = null;
            Future<?> futureA = null;
            HostInfo writerHost = currentTopology.get(0);
            this.topologyService.addToDownHostList(writerHost);
            if (writerHost != null) {
                taskA = new ReconnectToWriterHandler(taskCompletedLatch, writerHost, this.topologyService, this.connectionProvider, this.reconnectWriterIntervalMs, this.log);
                futureA = executorService.submit(taskA);
            }
            WaitForNewWriterHandler taskB = new WaitForNewWriterHandler(taskCompletedLatch, currentTopology, this.topologyService, writerHost, this.connectionProvider, this.readerFailoverHandler, this.readTopologyIntervalMs, this.log);
            Future<?> futureB = executorService.submit(taskB);
            executorService.shutdown();
            try {
                isLatchZero = taskCompletedLatch.await(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw this.createInterruptedException(e);
            }
            if (!isLatchZero) {
                if (futureA != null) {
                    futureA.cancel(true);
                }
                futureB.cancel(true);
                ResolvedHostInfo e = new ResolvedHostInfo(false, false, null, null);
                return e;
            }
            while (!(futureA != null && futureA.isDone() || futureB.isDone())) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.createInterruptedException(e);
                }
            }
            if (futureA != null && futureA.isDone()) {
                if (taskA.isConnected()) {
                    futureB.cancel(true);
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.2", new Object[]{writerHost.getHostPortPair()}));
                    ResolvedHostInfo e = new ResolvedHostInfo(true, false, taskA.getTopology(), taskA.getCurrentConnection());
                    return e;
                }
                try {
                    futureB.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
                    ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(false, false, null, null);
                    if (executorService == null) return resolvedHostInfo;
                    if (executorService.isTerminated()) return resolvedHostInfo;
                    executorService.shutdownNow();
                    return resolvedHostInfo;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.createInterruptedException(e);
                }
                if (!taskB.isConnected()) {
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
                    ResolvedHostInfo newWriterHost = new ResolvedHostInfo(false, false, null, null);
                    return newWriterHost;
                }
                HostInfo newWriterHost = taskB.getTopology().get(0);
                String newWriterHostPair = newWriterHost == null ? "<null>" : newWriterHost.getHostPortPair();
                this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.4", new Object[]{newWriterHostPair}));
                ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(true, true, taskB.getTopology(), taskB.getCurrentConnection());
                return resolvedHostInfo;
            }
            if (futureB.isDone()) {
                if (taskB.isConnected()) {
                    HostInfo newWriterHost;
                    if (futureA != null) {
                        futureA.cancel(true);
                    }
                    String newWriterHostPair = (newWriterHost = taskB.getTopology().get(0)) == null ? "<null>" : newWriterHost.getHostPortPair();
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.4", new Object[]{newWriterHostPair}));
                    ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(true, true, taskB.getTopology(), taskB.getCurrentConnection());
                    return resolvedHostInfo;
                }
                if (futureA != null) {
                    try {
                        futureA.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException | TimeoutException e) {
                        this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
                        ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(false, false, null, null);
                        if (executorService == null) return resolvedHostInfo;
                        if (executorService.isTerminated()) return resolvedHostInfo;
                        executorService.shutdownNow();
                        return resolvedHostInfo;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw this.createInterruptedException(e);
                    }
                    if (taskA.isConnected()) {
                        this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.2", new Object[]{writerHost.getHostPortPair()}));
                        ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(true, false, taskA.getTopology(), taskA.getCurrentConnection());
                        return resolvedHostInfo;
                    }
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
                    ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(false, false, null, null);
                    return resolvedHostInfo;
                }
            }
            if (futureA != null) {
                futureA.cancel(true);
            }
            futureB.cancel(true);
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
            ResolvedHostInfo resolvedHostInfo = new ResolvedHostInfo(false, false, null, null);
            return resolvedHostInfo;
        }
        finally {
            if (executorService != null && !executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException(Messages.getString("ClusterAwareWriterFailoverHandler.1"), "70100", e);
    }

    private static class WaitForNewWriterHandler
    implements Runnable {
        private final CountDownLatch taskCompletedLatch;
        private List<HostInfo> latestTopology;
        private JdbcConnection currentConnection = null;
        private boolean isConnected;
        private final int readTopologyIntervalMs;
        private final TopologyService topologyService;
        private final HostInfo originalWriterHost;
        private final ConnectionProvider connectionProvider;
        private final List<HostInfo> currentTopology;
        private final ReaderFailoverHandler readerFailoverHandler;
        private final transient Log log;
        private HostInfo currentReaderHost;
        private JdbcConnection currentReaderConnection;

        public WaitForNewWriterHandler(CountDownLatch taskCompletedLatch, List<HostInfo> currentTopology, TopologyService topologyService, HostInfo currentHost, ConnectionProvider connectionProvider, ReaderFailoverHandler readerFailoverHandler, int readTopologyIntervalMs, Log log) {
            this.taskCompletedLatch = taskCompletedLatch;
            this.currentTopology = currentTopology;
            this.topologyService = topologyService;
            this.originalWriterHost = currentHost;
            this.connectionProvider = connectionProvider;
            this.readerFailoverHandler = readerFailoverHandler;
            this.readTopologyIntervalMs = readTopologyIntervalMs;
            this.log = log;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public List<HostInfo> getTopology() {
            return this.latestTopology;
        }

        public JdbcConnection getCurrentConnection() {
            return this.currentConnection;
        }

        @Override
        public void run() {
            this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.8"));
            try {
                if (this.currentTopology == null) {
                    this.isConnected = false;
                    return;
                }
                boolean success = false;
                while (!success) {
                    this.connectoToReader();
                    success = this.connectToNewWriter();
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                this.isConnected = false;
                this.currentConnection = null;
                this.latestTopology = null;
            }
            catch (Exception ex) {
                this.log.logError(ex);
                this.isConnected = false;
                this.currentConnection = null;
                this.latestTopology = null;
                throw ex;
            }
            finally {
                if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                    try {
                        this.currentReaderConnection.close();
                    }
                    catch (SQLException exception) {}
                }
                this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.9"));
                this.taskCompletedLatch.countDown();
            }
        }

        private void connectoToReader() throws InterruptedException {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.currentReaderConnection = null;
            int connIndex = -1;
            this.currentReaderHost = null;
            while (true) {
                try {
                    ConnectionAttemptResult connResult = this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    this.currentReaderConnection = connResult != null && connResult.isSuccess() ? connResult.getConnection() : null;
                    connIndex = connResult != null && connResult.isSuccess() ? connResult.getConnectionIndex() : -1;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.currentReaderConnection == null) {
                    this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.11"));
                } else {
                    this.currentReaderHost = this.currentTopology.get(connIndex);
                    if (this.currentReaderHost != null) break;
                }
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.10", new Object[]{connIndex, this.currentReaderHost.getHostPortPair()}));
        }

        private boolean connectToNewWriter() throws InterruptedException {
            while (true) {
                this.latestTopology = this.topologyService.getTopology(this.currentReaderConnection, true);
                if (this.latestTopology == null) {
                    return false;
                }
                if (!this.latestTopology.isEmpty()) {
                    this.logTopology();
                    HostInfo writerCandidate = this.latestTopology.get(0);
                    if (!(writerCandidate == null || this.originalWriterHost != null && this.isSame(writerCandidate, this.originalWriterHost))) {
                        try {
                            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.13", new Object[]{writerCandidate.getHostPortPair()}));
                            this.currentConnection = this.isSame(writerCandidate, this.currentReaderHost) ? this.currentReaderConnection : this.connectionProvider.connect(writerCandidate);
                            this.isConnected = true;
                            this.topologyService.removeFromDownHostList(writerCandidate);
                            return true;
                        }
                        catch (SQLException exception) {
                            this.topologyService.addToDownHostList(writerCandidate);
                        }
                    }
                }
                TimeUnit.MILLISECONDS.sleep(this.readTopologyIntervalMs);
            }
        }

        private boolean isSame(HostInfo writerCandidate, HostInfo originalWriter) {
            if (writerCandidate == null) {
                return false;
            }
            return writerCandidate.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID").equals(originalWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"));
        }

        private void logTopology() {
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < this.latestTopology.size(); ++i) {
                HostInfo hostInfo = this.latestTopology.get(i);
                msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
            }
            this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.12", new Object[]{msg.toString()}));
        }
    }

    private static class ReconnectToWriterHandler
    implements Runnable {
        private List<HostInfo> latestTopology = null;
        private final HostInfo currentWriterHost;
        private final CountDownLatch taskCompletedLatch;
        private boolean isConnected = false;
        private JdbcConnection currentConnection = null;
        private final ConnectionProvider connectionProvider;
        private final TopologyService topologyService;
        private final int reconnectWriterIntervalMs;
        private final transient Log log;

        public ReconnectToWriterHandler(CountDownLatch taskCompletedLatch, HostInfo host, TopologyService topologyService, ConnectionProvider connectionProvider, int reconnectWriterIntervalMs, Log log) {
            this.taskCompletedLatch = taskCompletedLatch;
            this.currentWriterHost = host;
            this.topologyService = topologyService;
            this.connectionProvider = connectionProvider;
            this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
            this.log = log;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public JdbcConnection getCurrentConnection() {
            return this.currentConnection;
        }

        public List<HostInfo> getTopology() {
            return this.latestTopology;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block12: {
                try {
                    this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.6"));
                    while (true) {
                        block13: {
                            block11: {
                                this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.5", new Object[]{this.currentWriterHost.getHostPortPair()}));
                                ConnectionImpl conn = this.connectionProvider.connect(this.currentWriterHost);
                                this.latestTopology = this.topologyService.getTopology(conn, true);
                                if (this.latestTopology == null || this.latestTopology.isEmpty() || !this.isCurrentHostWriter()) break block11;
                                this.isConnected = true;
                                this.currentConnection = conn;
                                this.topologyService.removeFromDownHostList(this.currentWriterHost);
                                return;
                            }
                            break block13;
                            catch (SQLException conn) {
                                // empty catch block
                            }
                        }
                        TimeUnit.MILLISECONDS.sleep(this.reconnectWriterIntervalMs);
                        continue;
                        break;
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                        this.isConnected = false;
                        this.currentConnection = null;
                        this.latestTopology = null;
                        break block12;
                    }
                    catch (Exception ex) {
                        this.log.logError(ex);
                        this.isConnected = false;
                        this.currentConnection = null;
                        this.latestTopology = null;
                        throw ex;
                    }
                }
                finally {
                    this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.7"));
                    this.taskCompletedLatch.countDown();
                }
            }
        }

        private boolean isCurrentHostWriter() {
            String currentInstanceName = this.currentWriterHost.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            HostInfo latestWriter = this.latestTopology.get(0);
            if (latestWriter == null) {
                return false;
            }
            String latestWriterInstanceName = latestWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            return currentInstanceName.equals(latestWriterInstanceName);
        }
    }
}

