/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareHitMissMetricsHolder;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareTimeMetricsHolder;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;

public class ClusterAwareMetrics {
    private ClusterAwareTimeMetricsHolder failureDetection = new ClusterAwareTimeMetricsHolder("Failover Detection");
    private ClusterAwareTimeMetricsHolder writerFailoverProcedure = new ClusterAwareTimeMetricsHolder("Writer Failover Procedure");
    private ClusterAwareTimeMetricsHolder readerFailoverProcedure = new ClusterAwareTimeMetricsHolder("Reader Failover Procedure");
    private ClusterAwareHitMissMetricsHolder failoverConnects = new ClusterAwareHitMissMetricsHolder("Successful Failover Reconnects");
    private ClusterAwareHitMissMetricsHolder invalidInitialConnection = new ClusterAwareHitMissMetricsHolder("Invalid Initial Connection");
    private ClusterAwareHitMissMetricsHolder useLastConnectedReader = new ClusterAwareHitMissMetricsHolder("Used Last Connected Reader");
    private ClusterAwareHitMissMetricsHolder useCachedTopology = new ClusterAwareHitMissMetricsHolder("Used Cached Topology");

    public void registerFailureDetectionTime(long timeMs) {
        this.failureDetection.registerQueryExecutionTime(timeMs);
    }

    public void registerWriterFailoverProcedureTime(long timeMs) {
        this.writerFailoverProcedure.registerQueryExecutionTime(timeMs);
    }

    public void registerReaderFailoverProcedureTime(long timeMs) {
        this.readerFailoverProcedure.registerQueryExecutionTime(timeMs);
    }

    public void registerFailoverConnects(boolean isHit) {
        this.failoverConnects.register(isHit);
    }

    public void registerInvalidInitialConnection(boolean isHit) {
        this.invalidInitialConnection.register(isHit);
    }

    public void registerUseLastConnectedReader(boolean isHit) {
        this.useLastConnectedReader.register(isHit);
    }

    public void registerUseCachedTopology(boolean isHit) {
        this.useCachedTopology.register(isHit);
    }

    public void reportMetrics(Log log) {
        this.failoverConnects.reportMetrics(log);
        this.failureDetection.reportMetrics(log);
        this.writerFailoverProcedure.reportMetrics(log);
        this.readerFailoverProcedure.reportMetrics(log);
        this.useCachedTopology.reportMetrics(log);
        this.useLastConnectedReader.reportMetrics(log);
        this.invalidInitialConnection.reportMetrics(log);
    }
}

