/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import java.io.EOFException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import software.aws.rds.jdbc.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.shading.com.mysql.cj.NativeSession;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.ConnectionUrlParser;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.RuntimeProperty;
import software.aws.rds.jdbc.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.shading.com.mysql.cj.exceptions.CJException;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.JdbcPropertySetImpl;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.exceptions.CommunicationsException;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.exceptions.SQLError;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.AuroraTopologyService;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.BasicConnectionProvider;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.CanCollectPerformanceMetrics;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareConnectionLifecycleInterceptor;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareMetrics;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareReaderFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareWriterFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionAttemptResult;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ResolvedHostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.interceptors.ConnectionLifecycleInterceptor;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.interceptors.ConnectionLifecycleInterceptorProvider;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.LogFactory;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.shading.com.mysql.cj.util.IpAddressUtils;
import software.aws.rds.jdbc.shading.com.mysql.cj.util.StringUtils;

public class ClusterAwareConnectionProxy
extends MultiHostConnectionProxy
implements ConnectionLifecycleInterceptorProvider {
    static final String METHOD_SET_READ_ONLY = "setReadOnly";
    static final String METHOD_SET_AUTO_COMMIT = "setAutoCommit";
    static final String METHOD_COMMIT = "commit";
    static final String METHOD_ROLLBACK = "rollback";
    static final String METHOD_CLOSE = "close";
    private final Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraCustomClusterPattern = Pattern.compile("(.+)\\.(cluster-custom-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraProxyDnsPattern = Pattern.compile("(.+)\\.(proxy-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    protected static final int DEFAULT_CONNECT_TIMEOUT_MS = 30000;
    protected static final int NO_CONNECTION_INDEX = -1;
    protected static final int WRITER_CONNECTION_INDEX = 0;
    protected int currentHostIndex = -1;
    protected Boolean explicitlyReadOnly = null;
    protected boolean inTransaction = false;
    protected boolean explicitlyAutoCommit = true;
    protected boolean isClusterTopologyAvailable = false;
    protected boolean isMultiWriterCluster = false;
    protected boolean isRdsProxy = false;
    protected boolean isRds = false;
    protected TopologyService topologyService;
    protected List<HostInfo> hosts;
    protected WriterFailoverHandler writerFailoverHandler;
    protected ReaderFailoverHandler readerFailoverHandler;
    protected ConnectionProvider connectionProvider;
    protected ClusterAwareMetrics metrics = new ClusterAwareMetrics();
    private long invokeStartTimeMs;
    private long failoverStartTimeMs;
    protected boolean enableFailoverSetting = true;
    protected int clusterTopologyRefreshRateMsSetting;
    protected String loggerClassNameSetting;
    protected boolean gatherPerfMetricsSetting;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected String clusterIdSetting;
    protected String clusterInstanceHostPatternSetting;
    protected int failoverConnectTimeoutMs;
    protected int failoverSocketTimeoutMs;

    public ClusterAwareConnectionProxy(ConnectionUrl connectionUrl) throws SQLException {
        super(connectionUrl);
        this.initSettings(connectionUrl);
        this.initLogger();
        AuroraTopologyService topologyService = new AuroraTopologyService();
        topologyService.setPerformanceMetricsEnabled(this.gatherPerfMetricsSetting);
        topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        this.topologyService = topologyService;
        this.connectionProvider = new BasicConnectionProvider();
        this.readerFailoverHandler = new ClusterAwareReaderFailoverHandler(this.topologyService, this.connectionProvider, this.failoverReaderConnectTimeoutMsSetting, this.log);
        this.writerFailoverHandler = new ClusterAwareWriterFailoverHandler(this.topologyService, this.connectionProvider, this.readerFailoverHandler, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting, this.log);
        this.initClusterInfo(connectionUrl);
    }

    ClusterAwareConnectionProxy(ConnectionUrl connectionUrl, ConnectionProvider connectionProvider, TopologyService service, WriterFailoverHandler writerFailoverHandler, ReaderFailoverHandler readerFailoverHandler) throws SQLException {
        super(connectionUrl);
        this.initSettings(connectionUrl);
        this.initLogger();
        this.topologyService = service;
        this.topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        if (this.topologyService instanceof CanCollectPerformanceMetrics) {
            ((CanCollectPerformanceMetrics)((Object)this.topologyService)).setPerformanceMetricsEnabled(this.gatherPerfMetricsSetting);
        }
        this.connectionProvider = connectionProvider;
        this.writerFailoverHandler = writerFailoverHandler;
        this.readerFailoverHandler = readerFailoverHandler;
        this.initClusterInfo(connectionUrl);
    }

    public static JdbcConnection autodetectClusterAndCreateProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        ClusterAwareConnectionProxy connProxy = new ClusterAwareConnectionProxy(connectionUrl);
        if (connProxy.isFailoverEnabled()) {
            return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
        }
        connProxy.currentConnection.setProxy(null);
        return connProxy.currentConnection;
    }

    public static JdbcConnection createProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        ClusterAwareConnectionProxy connProxy = new ClusterAwareConnectionProxy(connectionUrl);
        return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
    }

    protected synchronized void initSettings(ConnectionUrl connectionUrl) throws SQLException {
        JdbcPropertySetImpl connProps = new JdbcPropertySetImpl();
        try {
            connProps.initializeProperties(connectionUrl.getMainHost().exposeAsProperties());
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, null);
        }
        this.enableFailoverSetting = connProps.getBooleanProperty(PropertyKey.enableClusterAwareFailover).getValue();
        this.clusterTopologyRefreshRateMsSetting = connProps.getIntegerProperty(PropertyKey.clusterTopologyRefreshRateMs).getValue();
        this.gatherPerfMetricsSetting = connProps.getBooleanProperty(PropertyKey.gatherPerfMetrics).getValue();
        this.loggerClassNameSetting = connProps.getStringProperty(PropertyKey.logger).getValue();
        this.failoverTimeoutMsSetting = connProps.getIntegerProperty(PropertyKey.failoverTimeoutMs).getValue();
        this.failoverClusterTopologyRefreshRateMsSetting = connProps.getIntegerProperty(PropertyKey.failoverClusterTopologyRefreshRateMs).getValue();
        this.failoverWriterReconnectIntervalMsSetting = connProps.getIntegerProperty(PropertyKey.failoverWriterReconnectIntervalMs).getValue();
        this.failoverReaderConnectTimeoutMsSetting = connProps.getIntegerProperty(PropertyKey.failoverReaderConnectTimeoutMs).getValue();
        this.clusterIdSetting = connProps.getStringProperty(PropertyKey.clusterId).getValue();
        this.clusterInstanceHostPatternSetting = connProps.getStringProperty(PropertyKey.clusterInstanceHostPattern).getValue();
        RuntimeProperty<Integer> connectTimeout = connProps.getIntegerProperty(PropertyKey.connectTimeout);
        this.failoverConnectTimeoutMs = connectTimeout.isExplicitlySet() ? connectTimeout.getValue() : 30000;
        RuntimeProperty<Integer> socketTimeout = connProps.getIntegerProperty(PropertyKey.socketTimeout);
        this.failoverSocketTimeoutMs = socketTimeout.isExplicitlySet() ? socketTimeout.getValue() : 10000;
    }

    protected synchronized void initLogger() {
        if (!StringUtils.isNullOrEmpty(this.loggerClassNameSetting)) {
            this.log = LogFactory.getLogger(this.loggerClassNameSetting, "MySQL");
        }
    }

    public boolean isClusterTopologyAvailable() {
        return this.isClusterTopologyAvailable;
    }

    public boolean isRds() {
        return this.isRds;
    }

    public boolean isRdsProxy() {
        return this.isRdsProxy;
    }

    public boolean isMultiWriterCluster() {
        return this.isMultiWriterCluster;
    }

    public boolean isFailoverEnabled() {
        return this.enableFailoverSetting && !this.isRdsProxy && this.isClusterTopologyAvailable && !this.isMultiWriterCluster;
    }

    protected void initClusterInfo(ConnectionUrl connUrl) throws SQLException {
        if (!this.enableFailoverSetting) {
            this.currentConnection = this.connectionProvider.connect(connUrl.getMainHost());
            return;
        }
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.9"));
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"clusterId", this.clusterIdSetting}));
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"clusterInstanceHostPattern", this.clusterInstanceHostPatternSetting}));
        HostInfo mainHost = this.connectionUrl.getMainHost();
        if (!StringUtils.isNullOrEmpty(this.clusterInstanceHostPatternSetting)) {
            String clusterRdsHostUrl;
            int instanceHostPort;
            ConnectionUrlParser.Pair<String, Integer> pair = ConnectionUrlParser.parseHostPortPair(this.clusterInstanceHostPatternSetting);
            if (pair == null) {
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.5"));
            }
            String instanceHostPattern = (String)pair.left;
            int n = instanceHostPort = (Integer)pair.right != -1 ? ((Integer)pair.right).intValue() : mainHost.getPort();
            if (!this.isDnsPatternValid(instanceHostPattern)) {
                this.log.logError(Messages.getString("ClusterAwareConnectionProxy.5"));
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.5"));
            }
            this.topologyService.setClusterInstanceHost(this.createClusterInstanceHost(mainHost, instanceHostPattern, instanceHostPort));
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{instanceHostPattern, instanceHostPort}));
            this.isRds = this.isRdsDns(instanceHostPattern);
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRds", this.isRds}));
            this.isRdsProxy = this.isRdsProxyDns(instanceHostPattern);
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRdsProxy", this.isRdsProxy}));
            boolean isRdsCustomCluster = this.isRdsCustomClusterDns(instanceHostPattern);
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRdsCustomCluster", isRdsCustomCluster}));
            if (this.isRdsProxy) {
                this.log.logError(Messages.getString("ClusterAwareConnectionProxy.8"));
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.8"));
            }
            if (isRdsCustomCluster) {
                this.log.logError(Messages.getString("ClusterAwareConnectionProxy.24"));
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.24"));
            }
            if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
                this.topologyService.setClusterId(this.clusterIdSetting);
                this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", this.clusterIdSetting}));
            } else if (this.isRds && !StringUtils.isNullOrEmpty(clusterRdsHostUrl = this.getRdsClusterHostUrl(instanceHostPattern))) {
                this.topologyService.setClusterId(clusterRdsHostUrl + ":" + instanceHostPort);
                this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", clusterRdsHostUrl + ":" + instanceHostPort}));
            }
            this.createConnectionAndInitializeTopology(connUrl);
        } else if (IpAddressUtils.isIPv4(mainHost.getHost()) || IpAddressUtils.isIPv6(mainHost.getHost())) {
            this.topologyService.setClusterInstanceHost(this.createClusterInstanceHost(mainHost, mainHost.getHost(), mainHost.getPort()));
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{mainHost.getHost(), mainHost.getPort()}));
            if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
                this.topologyService.setClusterId(this.clusterIdSetting);
                this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", this.clusterIdSetting}));
            }
            this.createConnectionAndInitializeTopology(connUrl);
            if (this.isClusterTopologyAvailable) {
                this.log.logError(Messages.getString("ClusterAwareConnectionProxy.6"));
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.6"));
            }
            this.isRds = false;
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRds", this.isRds}));
            this.isRdsProxy = false;
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRdsProxy", this.isRdsProxy}));
        } else {
            this.isRds = this.isRdsDns(mainHost.getHost());
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRds", this.isRds}));
            this.isRdsProxy = this.isRdsProxyDns(mainHost.getHost());
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isRdsProxy", this.isRdsProxy}));
            if (!this.isRds) {
                this.topologyService.setClusterInstanceHost(this.createClusterInstanceHost(mainHost, mainHost.getHost(), mainHost.getPort()));
                this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{mainHost.getHost(), mainHost.getPort()}));
                if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
                    this.topologyService.setClusterId(this.clusterIdSetting);
                    this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", this.clusterIdSetting}));
                }
                this.createConnectionAndInitializeTopology(connUrl);
                if (this.isClusterTopologyAvailable) {
                    this.log.logError(Messages.getString("ClusterAwareConnectionProxy.7"));
                    throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.7"));
                }
            } else {
                String rdsInstanceHostPattern = this.getRdsInstanceHostPattern(mainHost.getHost());
                this.topologyService.setClusterInstanceHost(this.createClusterInstanceHost(mainHost, rdsInstanceHostPattern, mainHost.getPort()));
                this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{rdsInstanceHostPattern, mainHost.getPort()}));
                if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
                    this.topologyService.setClusterId(this.clusterIdSetting);
                    this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", this.clusterIdSetting}));
                } else if (this.isRdsProxy) {
                    this.topologyService.setClusterId(mainHost.getHost() + ":" + mainHost.getPort());
                    this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", mainHost.getHost() + ":" + mainHost.getPort()}));
                } else {
                    String clusterRdsHostUrl = this.getRdsClusterHostUrl(mainHost.getHost());
                    if (!StringUtils.isNullOrEmpty(clusterRdsHostUrl)) {
                        this.topologyService.setClusterId(clusterRdsHostUrl + ":" + mainHost.getPort());
                        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.13", new Object[]{"clusterId", clusterRdsHostUrl + ":" + mainHost.getPort()}));
                    }
                }
                this.createConnectionAndInitializeTopology(connUrl);
            }
        }
    }

    private HostInfo createClusterInstanceHost(HostInfo mainHost, String host, int port) {
        HashMap<String, String> properties = new HashMap<String, String>(mainHost.getHostProperties());
        properties.put(PropertyKey.connectTimeout.getKeyName(), String.valueOf(this.failoverConnectTimeoutMs));
        properties.put(PropertyKey.socketTimeout.getKeyName(), String.valueOf(this.failoverSocketTimeoutMs));
        return new HostInfo(this.connectionUrl, host, port, mainHost.getUser(), mainHost.getPassword(), mainHost.isPasswordless(), properties);
    }

    protected synchronized void createConnectionAndInitializeTopology(ConnectionUrl connUrl) throws SQLException {
        this.createInitialConnection(connUrl);
        this.initTopology();
        if (this.isFailoverEnabled()) {
            this.validateInitialConnection();
            HostInfo currentHost = this.hosts.get(this.currentHostIndex);
            if (currentHost != null && this.isExplicitlyReadOnly()) {
                this.topologyService.setLastUsedReaderHost(currentHost);
            }
            this.currentConnection.getPropertySet().getIntegerProperty(PropertyKey.socketTimeout).setValue(this.failoverSocketTimeoutMs);
            ((NativeSession)this.currentConnection.getSession()).setSocketTimeout(this.failoverSocketTimeoutMs);
        }
    }

    private synchronized void createInitialConnection(ConnectionUrl connUrl) throws SQLException {
        String host = connUrl.getMainHost().getHost();
        if (this.isRdsClusterDns(host)) {
            this.explicitlyReadOnly = this.isReaderClusterDns(host);
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            try {
                this.attemptConnectionUsingCachedTopology();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!this.isConnected()) {
            this.currentConnection = this.connectionProvider.connect(connUrl.getMainHost());
            this.setConnectionProxy(this.currentConnection);
        }
    }

    private void attemptConnectionUsingCachedTopology() throws SQLException {
        int candidateIndex;
        this.hosts = this.topologyService.getCachedTopology();
        if (this.hosts == null || this.hosts.isEmpty()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerUseCachedTopology(false);
            }
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerUseCachedTopology(true);
        }
        if ((candidateIndex = this.getCandidateIndexForInitialConnection()) != -1) {
            this.connectTo(candidateIndex);
        }
    }

    private int getCandidateIndexForInitialConnection() {
        int candidateReaderIndex;
        if (this.isExplicitlyReadOnly() && (candidateReaderIndex = this.getCandidateReaderForInitialConnection()) != -1) {
            return candidateReaderIndex;
        }
        return this.hosts.get(0) != null ? 0 : -1;
    }

    private int getCandidateReaderForInitialConnection() {
        int lastUsedReaderIndex = this.getHostIndex(this.topologyService.getLastUsedReaderHost());
        if (lastUsedReaderIndex != -1) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerUseLastConnectedReader(true);
            }
            return lastUsedReaderIndex;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerUseLastConnectedReader(false);
        }
        if (this.clusterContainsReader()) {
            return this.getRandomReaderIndex();
        }
        return -1;
    }

    private synchronized void initTopology() {
        this.hosts = this.topologyService.getTopology(this.currentConnection, false);
        this.isClusterTopologyAvailable = this.hosts != null && !this.hosts.isEmpty();
        this.isMultiWriterCluster = this.topologyService.isMultiWriterCluster();
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"isClusterTopologyAvailable", this.isClusterTopologyAvailable}));
        if (this.isFailoverEnabled()) {
            this.logTopology();
        }
    }

    private synchronized void validateInitialConnection() throws SQLException {
        this.currentHostIndex = this.getHostIndex(this.topologyService.getHostByName(this.currentConnection));
        if (!this.isConnected()) {
            this.pickNewConnection();
            return;
        }
        if (!this.invalidWriterConnection()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerInvalidInitialConnection(false);
            }
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerInvalidInitialConnection(true);
        }
        if (this.hosts.get(0) == null) {
            if (this.gatherPerfMetricsSetting) {
                this.failoverStartTimeMs = System.currentTimeMillis();
            }
            this.failover(0);
            return;
        }
        try {
            this.connectTo(0);
        }
        catch (SQLException e) {
            if (this.gatherPerfMetricsSetting) {
                this.failoverStartTimeMs = System.currentTimeMillis();
            }
            this.failover(0);
        }
    }

    private boolean isDnsPatternValid(String pattern) {
        return pattern.contains("?");
    }

    private boolean isRdsDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return matcher.find();
    }

    private boolean isRdsProxyDns(String host) {
        Matcher matcher = this.auroraProxyDnsPattern.matcher(host);
        return matcher.find();
    }

    private boolean isRdsCustomClusterDns(String host) {
        Matcher matcher = this.auroraCustomClusterPattern.matcher(host);
        return matcher.find();
    }

    private String getRdsClusterHostUrl(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        if ("cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword)) {
            return matcher.group(1) + ".cluster-" + matcher.group(3);
        }
        return null;
    }

    private String getRdsInstanceHostPattern(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        if (matcher.find()) {
            return "?." + matcher.group(3);
        }
        return null;
    }

    private boolean isRdsClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        return "cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword);
    }

    private boolean isReaderClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return "cluster-ro-".equalsIgnoreCase(this.getClusterKeyword(matcher));
    }

    private String getClusterKeyword(Matcher matcher) {
        if (matcher.find() && matcher.group(2) != null && matcher.group(1) != null && !matcher.group(1).isEmpty()) {
            return matcher.group(2);
        }
        return null;
    }

    private int getRandomReaderIndex() {
        int max = this.hosts.size() - 1;
        int min = 1;
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    private boolean invalidWriterConnection() {
        return this.explicitlyReadOnly != null && this.explicitlyReadOnly == false && !this.isWriterHostIndex(this.currentHostIndex);
    }

    private boolean isExplicitlyReadOnly() {
        return this.explicitlyReadOnly != null && this.explicitlyReadOnly != false;
    }

    private boolean shouldPerformWriterFailover() {
        return this.explicitlyReadOnly == null || this.explicitlyReadOnly == false;
    }

    private void logTopology() {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo hostInfo = this.hosts.get(i);
            msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
        }
        this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.16", new Object[]{msg.toString()}));
    }

    @Override
    protected synchronized void invalidateCurrentConnection() throws SQLException {
        if (this.inTransaction) {
            try {
                this.currentConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.invalidateConnection(this.currentConnection);
    }

    @Override
    protected synchronized void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.17"), t);
            if (this.lastExceptionDealtWith != t && this.shouldExceptionTriggerConnectionSwitch(t)) {
                if (this.gatherPerfMetricsSetting) {
                    long currentTimeMs = System.currentTimeMillis();
                    this.metrics.registerFailureDetectionTime(currentTimeMs - this.invokeStartTimeMs);
                    this.invokeStartTimeMs = 0L;
                    this.failoverStartTimeMs = currentTimeMs;
                }
                this.invalidateCurrentConnection();
                this.pickNewConnection();
                this.lastExceptionDealtWith = t;
            }
            throw t;
        }
        throw e;
    }

    @Override
    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (!this.isFailoverEnabled()) {
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.18"));
            return false;
        }
        String sqlState = null;
        if (t instanceof CommunicationsException || t instanceof CJCommunicationsException) {
            return true;
        }
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        } else if (t instanceof CJException) {
            if (t.getCause() instanceof EOFException) {
                return true;
            }
            if (t.getCause() instanceof SSLException) {
                return true;
            }
            sqlState = ((CJException)t).getSQLState();
        }
        if (sqlState != null) {
            return sqlState.startsWith("08");
        }
        return false;
    }

    @Override
    protected boolean isMasterConnection() {
        return this.isWriterHostIndex(this.currentHostIndex);
    }

    synchronized boolean isConnected() {
        return this.currentHostIndex != -1;
    }

    @Override
    protected synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.19"));
            return;
        }
        if (this.isConnected()) {
            this.failover(this.currentHostIndex);
            return;
        }
        if (this.shouldAttemptReaderConnection()) {
            this.failoverReader(-1);
            return;
        }
        if (this.hosts.get(0) == null) {
            this.failover(0);
            return;
        }
        try {
            this.connectTo(0);
            if (this.isExplicitlyReadOnly()) {
                this.topologyService.setLastUsedReaderHost(this.hosts.get(this.currentHostIndex));
            }
        }
        catch (SQLException e) {
            this.failover(0);
        }
    }

    private boolean shouldAttemptReaderConnection() {
        return this.isExplicitlyReadOnly() && this.clusterContainsReader();
    }

    private boolean clusterContainsReader() {
        return this.hosts.size() > 1;
    }

    private int getHostIndex(HostInfo host) {
        if (host == null) {
            return -1;
        }
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo potentialMatch = this.hosts.get(i);
            if (potentialMatch == null || !potentialMatch.equalHostPortPair(host)) continue;
            return i;
        }
        return -1;
    }

    private synchronized void connectTo(int hostIndex) throws SQLException {
        try {
            this.switchCurrentConnectionTo(hostIndex, this.createConnectionForHostIndex(hostIndex));
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.20", new Object[]{this.hosts.get(hostIndex)}));
        }
        catch (SQLException e) {
            if (this.currentConnection != null) {
                HostInfo host = this.hosts.get(hostIndex);
                StringBuilder msg = new StringBuilder("Connection to ").append(this.isWriterHostIndex(hostIndex) ? "writer" : "reader").append(" host '").append(host == null ? "<null>" : host.getHostPortPair()).append("' failed");
                try {
                    this.log.logWarn(msg.toString(), e);
                }
                catch (CJException ex) {
                    throw SQLExceptionsMapping.translateException(e, this.currentConnection.getExceptionInterceptor());
                }
            }
            throw e;
        }
    }

    private synchronized ConnectionImpl createConnectionForHostIndex(int hostIndex) throws SQLException {
        return this.createConnectionForHost(this.hosts.get(hostIndex));
    }

    @Override
    protected synchronized ConnectionImpl createConnectionForHost(HostInfo hostInfo) throws SQLException {
        ConnectionImpl conn = this.connectionProvider.connect(hostInfo);
        this.setConnectionProxy(conn);
        return conn;
    }

    protected void setConnectionProxy(JdbcConnection conn) {
        JdbcConnection topmostProxy = this.getProxy();
        if (topmostProxy != this.thisAsConnection) {
            conn.setProxy(this.thisAsConnection);
        }
        conn.setProxy(topmostProxy);
    }

    private synchronized void switchCurrentConnectionTo(int hostIndex, JdbcConnection connection) throws SQLException {
        this.invalidateCurrentConnection();
        boolean readOnly = this.isWriterHostIndex(hostIndex) ? this.isExplicitlyReadOnly() : (this.explicitlyReadOnly != null ? this.explicitlyReadOnly : (this.currentConnection != null ? this.currentConnection.isReadOnly() : false));
        this.syncSessionState(this.currentConnection, connection, readOnly);
        this.currentConnection = connection;
        this.currentHostIndex = hostIndex;
        this.inTransaction = false;
    }

    private synchronized boolean isWriterHostIndex(int hostIndex) {
        return hostIndex == 0;
    }

    protected synchronized boolean isCurrentConnectionReadOnly() {
        return this.isConnected() && !this.isWriterHostIndex(this.currentHostIndex);
    }

    protected synchronized boolean isCurrentConnectionWriter() {
        return this.isWriterHostIndex(this.currentHostIndex);
    }

    protected synchronized void failover(int failedHostIdx) throws SQLException {
        if (this.shouldPerformWriterFailover()) {
            this.failoverWriter();
        } else {
            this.failoverReader(failedHostIdx);
        }
        if (this.inTransaction) {
            this.inTransaction = false;
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.1"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.1"), "08007");
        }
        this.log.logError(Messages.getString("ClusterAwareConnectionProxy.3"));
        throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.3"), "08S02");
    }

    protected void failoverWriter() throws SQLException {
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.21"));
        ResolvedHostInfo failoverResult = this.writerFailoverHandler.failover(this.hosts);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerWriterFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (failoverResult == null || !failoverResult.isConnected()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerFailoverConnects(false);
            }
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.2"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.2"), "08001");
        }
        if (failoverResult.isNewHost()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerFailoverConnects(true);
            }
            this.hosts = failoverResult.getTopology();
            this.currentHostIndex = 0;
            this.currentConnection = failoverResult.getNewConnection();
            this.setConnectionProxy(this.currentConnection);
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.20", new Object[]{this.hosts.get(this.currentHostIndex)}));
        } else {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerFailoverConnects(true);
            }
            this.currentHostIndex = 0;
            this.currentConnection = failoverResult.getNewConnection();
            this.setConnectionProxy(this.currentConnection);
            this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.20", new Object[]{this.hosts.get(this.currentHostIndex)}));
        }
    }

    protected void failoverReader(int failedHostIdx) throws SQLException {
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.23"));
        HostInfo failedHost = failedHostIdx == -1 ? null : this.hosts.get(failedHostIdx);
        ConnectionAttemptResult result = this.readerFailoverHandler.failover(this.hosts, failedHost);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerReaderFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (result == null || !result.isSuccess()) {
            if (this.gatherPerfMetricsSetting) {
                this.metrics.registerFailoverConnects(false);
            }
            this.log.logError(Messages.getString("ClusterAwareConnectionProxy.4"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.4"), "08001");
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(true);
        }
        this.currentConnection = result.getConnection();
        this.setConnectionProxy(this.currentConnection);
        this.currentHostIndex = result.getConnectionIndex();
        this.updateTopologyAndConnectIfNeeded(true);
        this.log.logDebug(Messages.getString("ClusterAwareConnectionProxy.20", new Object[]{this.hosts.get(this.currentHostIndex)}));
        HostInfo currentHost = this.hosts.get(this.currentHostIndex);
        if (currentHost != null) {
            this.topologyService.setLastUsedReaderHost(currentHost);
        }
    }

    @Override
    protected synchronized void doClose() throws SQLException {
        this.currentConnection.close();
    }

    @Override
    protected synchronized void doAbortInternal() throws SQLException {
        this.currentConnection.abortInternal();
    }

    @Override
    protected synchronized void doAbort(Executor executor) throws SQLException {
        this.currentConnection.abort(executor);
    }

    protected void updateTopologyAndConnectIfNeeded(boolean forceUpdate) throws SQLException {
        if (!this.isFailoverEnabled() || this.currentConnection.isClosed()) {
            return;
        }
        List<HostInfo> latestTopology = this.topologyService.getTopology(this.currentConnection, forceUpdate);
        if (latestTopology == null) {
            return;
        }
        if (!this.isConnected()) {
            this.hosts = latestTopology;
            this.pickNewConnection();
            return;
        }
        HostInfo currentHost = this.hosts.get(this.currentHostIndex);
        int latestHostIndex = -1;
        for (int i = 0; i < latestTopology.size(); ++i) {
            HostInfo host = latestTopology.get(i);
            if (host == null || currentHost == null || !host.equalHostPortPair(currentHost)) continue;
            latestHostIndex = i;
            break;
        }
        if (latestHostIndex == -1) {
            this.hosts = latestTopology;
            this.currentHostIndex = -1;
            this.pickNewConnection();
        } else {
            this.hosts = latestTopology;
            this.currentHostIndex = latestHostIndex;
        }
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.invokeStartTimeMs = this.gatherPerfMetricsSetting ? System.currentTimeMillis() : 0L;
        Object result = super.invoke(proxy, method, args);
        if (METHOD_CLOSE.equals(method.getName()) && this.gatherPerfMetricsSetting) {
            this.metrics.reportMetrics(this.log);
            if (this.topologyService instanceof CanCollectPerformanceMetrics) {
                ((CanCollectPerformanceMetrics)((Object)this.topologyService)).reportMetrics(this.log);
            }
        }
        return result;
    }

    @Override
    public synchronized Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        this.updateTopologyAndConnectIfNeeded(false);
        if (this.isClosed && !this.allowedOnClosedConnection(method)) {
            if (this.autoReconnect && !this.closedExplicitly) {
                this.currentHostIndex = -1;
                this.isClosed = false;
                this.closedReason = null;
                this.pickNewConnection();
                this.log.logError(Messages.getString("ClusterAwareConnectionProxy.25"));
                throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.25"), "08S02");
            }
            String reason = "No operations allowed after connection closed.";
            if (this.closedReason != null) {
                reason = reason + "  " + this.closedReason;
            }
            throw SQLError.createSQLException(reason, "08003", null);
        }
        Object result = null;
        try {
            result = method.invoke((Object)this.thisAsConnection, args);
            result = this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
        }
        catch (InvocationTargetException e) {
            this.dealWithInvocationException(e);
        }
        if (METHOD_SET_AUTO_COMMIT.equals(methodName)) {
            this.explicitlyAutoCommit = (Boolean)args[0];
            boolean bl = this.inTransaction = !this.explicitlyAutoCommit;
        }
        if (METHOD_COMMIT.equals(methodName) || METHOD_ROLLBACK.equals(methodName)) {
            this.inTransaction = false;
        }
        if (METHOD_SET_READ_ONLY.equals(methodName)) {
            this.explicitlyReadOnly = (Boolean)args[0];
            this.log.logTrace(Messages.getString("ClusterAwareConnectionProxy.12", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            this.connectToWriterIfRequired(this.explicitlyReadOnly);
        }
        return result;
    }

    private void connectToWriterIfRequired(Boolean readOnly) throws SQLException {
        if (readOnly != null && !readOnly.booleanValue() && !this.isWriterHostIndex(this.currentHostIndex)) {
            if (this.hosts.get(0) == null) {
                this.failover(0);
                return;
            }
            try {
                this.connectTo(0);
            }
            catch (SQLException e) {
                this.failover(0);
            }
        }
    }

    @Override
    public ConnectionLifecycleInterceptor getConnectionLifecycleInterceptor() {
        return new ClusterAwareConnectionLifecycleInterceptor(this);
    }

    protected JdbcConnection getConnection() {
        return this.currentConnection;
    }
}

