/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.video;

import android.os.Handler;
import com.xodee.client.video.VideoFrameBuffer;
import com.xodee.client.video.VideoFrameBufferAdapter;
import com.xodee.client.video.VideoFrameI420Buffer;
import com.xodee.client.video.VideoFrameI420BufferAdapter;
import com.xodee.client.video.VideoFrameRGBABuffer;
import com.xodee.client.video.VideoFrameRGBABufferAdapter;
import com.xodee.client.video.VideoFrameTextureBuffer;
import com.xodee.client.video.VideoFrameTextureBufferAdapter;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import org.amazon.chime.webrtc.JavaI420Buffer;
import org.amazon.chime.webrtc.TextureBufferImpl;
import org.amazon.chime.webrtc.VideoFrame;
import org.amazon.chime.webrtc.YuvConverter;

public class VideoFrame {
    private int width;
    private int height;
    private long timestampNs;
    private int rotation;
    private VideoFrameBuffer buffer;

    public VideoFrame(int width, int height, long timestampNs, int rotation, VideoFrameBuffer buffer) {
        this.width = width;
        this.height = height;
        this.timestampNs = timestampNs;
        this.rotation = rotation;
        this.buffer = buffer;
    }

    public VideoFrame(org.amazon.chime.webrtc.VideoFrame frame) {
        this.width = frame.getRotatedWidth();
        this.height = frame.getRotatedHeight();
        this.timestampNs = frame.getTimestampNs();
        this.rotation = frame.getRotation();
        this.buffer = frame.getBuffer() instanceof VideoFrame.TextureBuffer ? new VideoFrameTextureBufferAdapter.WebRTCToMedia((VideoFrame.TextureBuffer)frame.getBuffer()) : (frame.getBuffer() instanceof VideoFrame.I420Buffer ? new VideoFrameI420BufferAdapter.WebRTCToMedia((VideoFrame.I420Buffer)frame.getBuffer()) : new VideoFrameBufferAdapter.WebRTCToMedia(frame.getBuffer()));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotation() {
        return this.rotation;
    }

    public VideoFrameBuffer getBuffer() {
        return this.buffer;
    }

    org.amazon.chime.webrtc.VideoFrame toWebRTCVideoFrame(Handler handler, YuvConverter yuvConverter) {
        VideoFrameRGBABufferAdapter.MediaToWebRTC webrtcBuffer = null;
        if (this.buffer instanceof VideoFrameTextureBuffer) {
            VideoFrameTextureBuffer textureBuffer = (VideoFrameTextureBuffer)this.buffer;
            webrtcBuffer = new TextureBufferImpl(textureBuffer.getWidth(), textureBuffer.getHeight(), switch (textureBuffer.getType()) {
                case VideoFrameTextureBuffer.Type.OES -> VideoFrame.TextureBuffer.Type.OES;
                default -> VideoFrame.TextureBuffer.Type.RGB;
            }, textureBuffer.getTextureId(), textureBuffer.getTransformMatrix(), handler, yuvConverter, textureBuffer::release);
        } else if (this.buffer instanceof VideoFrameI420Buffer) {
            VideoFrameI420Buffer i420buffer = (VideoFrameI420Buffer)this.buffer;
            webrtcBuffer = JavaI420Buffer.wrap((int)i420buffer.getWidth(), (int)i420buffer.getHeight(), (ByteBuffer)i420buffer.getDataY(), (int)i420buffer.getStrideY(), (ByteBuffer)i420buffer.getDataU(), (int)i420buffer.getStrideU(), (ByteBuffer)i420buffer.getDataV(), (int)i420buffer.getStrideV(), i420buffer::release);
        } else if (this.buffer instanceof VideoFrameRGBABuffer) {
            VideoFrameRGBABuffer rgbaBuffer = (VideoFrameRGBABuffer)this.buffer;
            webrtcBuffer = new VideoFrameRGBABufferAdapter.MediaToWebRTC(rgbaBuffer);
        } else {
            throw new InvalidParameterException("MediaSDK only supports texture, I420, and RGBA video frame buffers");
        }
        return new org.amazon.chime.webrtc.VideoFrame((VideoFrame.Buffer)webrtcBuffer, this.rotation, this.timestampNs);
    }
}

