/*
 * Decompiled with CFR 0.152.
 */
package com.biba.bibacommon;

import android.util.Log;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxyConfig {
    private static final String TAG = ProxyConfig.class.getSimpleName();
    public int scheme;
    public int port;
    public String address;
    public String username;
    public String password;

    public ProxyConfig(Proxy p) {
        if (p == Proxy.NO_PROXY) {
            this.scheme = Scheme.PX_SCHEME_DIRECT.ordinal();
            this.address = null;
            this.port = 0;
            return;
        }
        this.scheme = (switch (p.type()) {
            case Proxy.Type.HTTP -> Scheme.PX_SCHEME_HTTP;
            case Proxy.Type.SOCKS -> Scheme.PX_SCHEME_SOCKS;
            default -> Scheme.PX_SCHEME_DIRECT;
        }).ordinal();
        InetSocketAddress proxyAddress = null;
        try {
            proxyAddress = (InetSocketAddress)p.address();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Unable to get proxy socket address", (Throwable)e);
            proxyAddress = null;
            throw e;
        }
        try {
            this.address = proxyAddress.getHostName();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Unable to get proxy host name", (Throwable)e);
            this.address = null;
            throw e;
        }
        try {
            this.port = proxyAddress.getPort();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Unable to get proxy host port", (Throwable)e);
            this.port = 0;
            throw e;
        }
    }

    public static enum Scheme {
        PX_SCHEME_DIRECT,
        PX_SCHEME_WPAD,
        PX_SCHEME_PAC,
        PX_SCHEME_HTTP,
        PX_SCHEME_SOCKS;

    }
}

