/*
 * Decompiled with CFR 0.152.
 */
package org.amazon.chime.webrtc;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.amazon.chime.webrtc.LibaomAv1Encoder;
import org.amazon.chime.webrtc.LibvpxVp8Encoder;
import org.amazon.chime.webrtc.LibvpxVp9Encoder;
import org.amazon.chime.webrtc.VideoCodecInfo;
import org.amazon.chime.webrtc.VideoCodecMimeType;
import org.amazon.chime.webrtc.VideoEncoder;
import org.amazon.chime.webrtc.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo codecInfo) {
        String codecName = codecInfo.getName();
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.VP8.name())) {
            return new LibvpxVp8Encoder();
        }
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.VP9.name()) && LibvpxVp9Encoder.nativeIsSupported()) {
            return new LibvpxVp9Encoder();
        }
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.AV1.name())) {
            return new LibaomAv1Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo(VideoCodecMimeType.VP8.name(), new HashMap<String, String>()));
        if (LibvpxVp9Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo(VideoCodecMimeType.VP9.name(), new HashMap<String, String>()));
        }
        codecs.add(new VideoCodecInfo(VideoCodecMimeType.AV1.name(), new HashMap<String, String>()));
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

