/*
 * Decompiled with CFR 0.152.
 */
package org.amazon.chime.webrtc;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.amazon.chime.webrtc.LibaomAv1Decoder;
import org.amazon.chime.webrtc.LibvpxVp8Decoder;
import org.amazon.chime.webrtc.LibvpxVp9Decoder;
import org.amazon.chime.webrtc.VideoCodecInfo;
import org.amazon.chime.webrtc.VideoCodecMimeType;
import org.amazon.chime.webrtc.VideoDecoder;
import org.amazon.chime.webrtc.VideoDecoderFactory;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecInfo) {
        String codecName = codecInfo.getName();
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.VP8.name())) {
            return new LibvpxVp8Decoder();
        }
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.VP9.name()) && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        if (codecName.equalsIgnoreCase(VideoCodecMimeType.AV1.name()) && LibaomAv1Decoder.nativeIsSupported()) {
            return new LibaomAv1Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo(VideoCodecMimeType.VP8.name(), new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo(VideoCodecMimeType.VP9.name(), new HashMap<String, String>()));
        }
        if (LibaomAv1Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo(VideoCodecMimeType.AV1.name(), new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

