/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.video;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.opengl.EGLContext;
import android.os.Build;
import android.text.TextUtils;
import com.xodee.client.video.RemoteVideoSourceInternal;
import com.xodee.client.video.VideoClientConfig;
import com.xodee.client.video.VideoClientDataMessageListener;
import com.xodee.client.video.VideoClientDelegate;
import com.xodee.client.video.VideoClientException;
import com.xodee.client.video.VideoClientLogListener;
import com.xodee.client.video.VideoSource;
import com.xodee.client.video.VideoSourceAdapter;
import com.xodee.client.video.VideoSubscriptionConfigurationInternal;
import java.util.List;
import java.util.Map;
import org.amazon.chime.webrtc.CapturerObserver;
import org.amazon.chime.webrtc.HardwareVideoDecoderFactory;
import org.amazon.chime.webrtc.HardwareVideoEncoderFactory;
import org.amazon.chime.webrtc.Logging;
import org.amazon.chime.webrtc.VideoCodecInfo;

public class VideoClient {
    private long peer = 0L;
    private static final String TAG = "JavaVideoClient";
    private VideoClientLogListener logListener;
    private VideoClientDataMessageListener messageListener;
    private VideoSourceAdapter videoSourceAdapter;
    public static final int VIDEO_CLIENT_OK = 0;
    public static final int VIDEO_CLIENT_ERR = 1;
    public static final int VIDEO_CLIENT_ERR_UNKNOWN_EVENT = 31;
    public static final int VIDEO_CLIENT_ERR_PRIMARY_MEETING_JOIN_AUTHENTICATION_FAILED = 65;
    public static final int VIDEO_CLIENT_ERR_PRIMARY_MEETING_JOIN_AT_CAPACITY = 66;
    public static final int VIDEO_CLIENT_STATUS_CALL_AT_CAPACITY = 509;
    public static final int VIDEO_CLIENT_STATUS_CALL_AT_CAPACITY_VIEW_ONLY = 206;
    public static final int ENCODER_INDEX = 0;
    public static final int DECODER_INDEX = 1;
    public static int[] maxConcurrentHwH264Codecs;
    public static final int VIDEO_CLIENT_NO_PAUSE = 0;
    public static final int VIDEO_CLIENT_LOCAL_PAUSED_BY_BAD_NETWORKING = 1;
    public static final int VIDEO_CLIENT_REMOTE_PAUSED_BY_USER = 2;
    public static final int VIDEO_CLIENT_REMOTE_PAUSED_BY_VSI = 3;
    public static final int VIDEO_CLIENT_REMOTE_PAUSED_BY_LOCAL_BAD_NETWORK = 4;
    public static final int VIDEO_AVAILABLE_SEND_BANDWIDTH = 0;
    public static final int VIDEO_AVAILABLE_RECEIVE_BANDWIDTH = 1;
    public static final int VIDEO_SEND_BITRATE = 2;
    public static final int VIDEO_SEND_PACKET_LOSS_PERCENT = 3;
    public static final int VIDEO_SEND_FPS = 4;
    public static final int VIDEO_SEND_RTT = 5;
    public static final int VIDEO_RECEIVE_BITRATE = 6;
    public static final int VIDEO_RECEIVE_PACKET_LOSS_PERCENT = 7;
    public static final int VIDEO_CONTENT_HINT_NONE = 0;
    public static final int VIDEO_CONTENT_HINT_MOTION = 1;
    public static final int VIDEO_CONTENT_HINT_DETAILED = 2;
    public static final int VIDEO_CONTENT_HINT_TEXT = 3;

    public VideoClient(VideoClientDelegate delegate, VideoClientLogListener logListener, VideoClientDataMessageListener messageListener) throws VideoClientException {
        boolean res = this.createPeer(delegate);
        if (!res) {
            throw new VideoClientException("VideoClient: nativeSetup failed res: " + res);
        }
        this.logListener = logListener;
        this.messageListener = messageListener;
    }

    public VideoClient(VideoClientDelegate delegate) throws VideoClientException {
        this(delegate, new VideoClientLogListener(){

            @Override
            public void onLogMessage(int logLevel, String message) {
                Logging.d((String)VideoClient.TAG, (String)("log level: " + logLevel + " message: " + message));
            }
        }, null);
    }

    public void javaStopService() {
        this.stopService();
    }

    public void sendDataMessage(String topic, byte[] data, int lifetimeMs) {
        this.doSendDataMessage(topic, data, lifetimeMs);
    }

    public void promoteToPrimaryMeeting(String attendeeId, String externalUserId, String sessionToken) {
        this.doPromoteToPrimaryMeeting(attendeeId, externalUserId, sessionToken);
    }

    public void demoteFromPrimaryMeeting() {
        this.doDemoteFromPrimaryMeeting();
    }

    public void updateVideoSourceSubscriptions(Map<RemoteVideoSourceInternal, VideoSubscriptionConfigurationInternal> addedOrUpdated, List<RemoteVideoSourceInternal> removed) {
        this.updateRemoteVideoSourceSubscriptions(addedOrUpdated, removed);
    }

    public void setMaxBitRateKbps(int maxBitRate) {
        this.doSetMaxBitRateKbps(maxBitRate);
    }

    public boolean start(VideoClientConfig config) {
        return this.doStart(config.getControlUrl(), config.getStunServerUrl(), config.getAudioHostUrl(), config.getMeetingId(), config.getToken(), config.isSending(), config.getAnalyticsRef(), config.getFlags(), config.getSharedEglContext(), config.getSignalingUrl());
    }

    public void setSending(Boolean sending) {
        this.doSetSending(sending);
    }

    public void setReceiving(Boolean receiving) {
        this.doSetReceiving(receiving);
    }

    public void destroy() {
        if (this.videoSourceAdapter != null) {
            this.videoSourceAdapter.release();
        }
        this.destroyPeer();
    }

    public static boolean javaInitializeGlobals(Context context) {
        return VideoClient.initializeGlobals(context);
    }

    private native boolean createPeer(VideoClientDelegate var1);

    public native boolean doStart(String var1, String var2, String var3, String var4, String var5, boolean var6, long var7, int var9, EGLContext var10, String var11);

    public native boolean isActive();

    public native void doSetSending(boolean var1);

    public native void doSetReceiving(boolean var1);

    public native void setRemotePause(int var1, boolean var2);

    public native int getState();

    public native void stopService();

    private native void destroyPeer();

    private native void doSendDataMessage(String var1, byte[] var2, int var3);

    private native void doPromoteToPrimaryMeeting(String var1, String var2, String var3);

    private native void doDemoteFromPrimaryMeeting();

    private native void updateRemoteVideoSourceSubscriptions(Map<RemoteVideoSourceInternal, VideoSubscriptionConfigurationInternal> var1, List<RemoteVideoSourceInternal> var2);

    private native void doSetMaxBitRateKbps(int var1);

    private native CapturerObserver getVideoCaptureObserver(int var1);

    public static native boolean initializeGlobals(Context var0);

    public static native boolean finalizeGlobals();

    public native void updateTurnCredentials(String var1, String var2, String var3, String[] var4, String var5, VideoClientTurnStatus var6);

    public static int[] getMaxConcurrentHwH264Codecs() {
        if (maxConcurrentHwH264Codecs[0] >= 0) {
            return maxConcurrentHwH264Codecs;
        }
        boolean supportHwH264Encoder = false;
        HardwareVideoEncoderFactory hwVideoEncFactory = new HardwareVideoEncoderFactory(null, false, false);
        VideoCodecInfo[] codecInfos = hwVideoEncFactory.getSupportedCodecs();
        hwVideoEncFactory = null;
        for (int i = 0; i < codecInfos.length; ++i) {
            if (codecInfos[i].name != "H264") continue;
            supportHwH264Encoder = true;
            break;
        }
        codecInfos = null;
        if (!supportHwH264Encoder) {
            VideoClient.maxConcurrentHwH264Codecs[0] = 0;
            Logging.d((String)TAG, (String)"WEBRTC does not support H/W H.264 encoder on non-Exynos non-Snapdragon chipset.");
        }
        boolean supportHwH264Decoder = false;
        HardwareVideoDecoderFactory hwVideoDecFactory = new HardwareVideoDecoderFactory(null);
        codecInfos = hwVideoDecFactory.getSupportedCodecs();
        hwVideoDecFactory = null;
        for (int i = 0; i < codecInfos.length; ++i) {
            if (codecInfos[i].name != "H264") continue;
            supportHwH264Decoder = true;
            break;
        }
        codecInfos = null;
        if (!supportHwH264Decoder) {
            Logging.d((String)TAG, (String)"Android device does NOT support H/W H.264 decoder");
            VideoClient.maxConcurrentHwH264Codecs[1] = 0;
        }
        Logging.d((String)TAG, (String)"Android H264 Codec:--------------START ");
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            String[] types = info.getSupportedTypes();
            for (String type : info.getSupportedTypes()) {
                if (!type.equalsIgnoreCase("video/avc")) continue;
                MediaCodecInfo.CodecCapabilities cap = info.getCapabilitiesForType("video/avc");
                boolean bIsHardwareCodec = false;
                if (Build.VERSION.SDK_INT >= 29) {
                    bIsHardwareCodec = info.isHardwareAccelerated();
                } else {
                    boolean bl = bIsHardwareCodec = !info.getName().contains("OMX.google.") && !info.getName().contains("OMX.SEC.");
                }
                if (info.isEncoder()) {
                    if (!bIsHardwareCodec) {
                        Logging.d((String)TAG, (String)("SW H264 Encoder: " + info.getName()));
                    } else {
                        Logging.d((String)TAG, (String)("HW H264 Encoder: " + info.getName()));
                    }
                } else if (!bIsHardwareCodec) {
                    Logging.d((String)TAG, (String)("SW H264 Decoder: " + info.getName()));
                } else {
                    Logging.d((String)TAG, (String)("HW H264 Decoder: " + info.getName()));
                }
                if (Build.VERSION.SDK_INT >= 23) {
                    int maxSupportedInstance = cap.getMaxSupportedInstances();
                    Logging.d((String)TAG, (String)("--> MaxSupportedInstances:" + maxSupportedInstance));
                    if (bIsHardwareCodec && !info.isEncoder() && (maxConcurrentHwH264Codecs[1] < 0 || maxConcurrentHwH264Codecs[1] > maxSupportedInstance)) {
                        VideoClient.maxConcurrentHwH264Codecs[1] = maxSupportedInstance;
                        continue;
                    }
                    if (!bIsHardwareCodec || !info.isEncoder() || maxConcurrentHwH264Codecs[0] >= 0 && maxConcurrentHwH264Codecs[0] <= maxSupportedInstance) continue;
                    VideoClient.maxConcurrentHwH264Codecs[0] = maxSupportedInstance;
                    continue;
                }
                if (maxConcurrentHwH264Codecs[0] < 0) {
                    VideoClient.maxConcurrentHwH264Codecs[0] = 3;
                }
                if (maxConcurrentHwH264Codecs[1] >= 0) continue;
                VideoClient.maxConcurrentHwH264Codecs[1] = 8;
            }
        }
        Logging.d((String)TAG, (String)("Android H264 Codec:  -----END (WEBRTC supported max H/W H264Encoder[" + maxConcurrentHwH264Codecs[0] + "];H/W H264Decoder[" + maxConcurrentHwH264Codecs[1] + "]"));
        return maxConcurrentHwH264Codecs;
    }

    public void setExternalVideoSource(VideoSource source, EGLContext sharedContext) {
        if (this.videoSourceAdapter == null) {
            CapturerObserver capturerObserver = this.getVideoCaptureObserver(source.getContentHint().getValue());
            this.videoSourceAdapter = new VideoSourceAdapter(capturerObserver, sharedContext);
        }
        this.videoSourceAdapter.setSource(source);
    }

    static {
        System.loadLibrary("c++_shared");
        System.loadLibrary("amazon_chime_media_client");
        maxConcurrentHwH264Codecs = new int[]{-1, -1};
    }

    public static enum VideoClientTurnStatus {
        VIDEO_CLIENT_TURN_FEATURE_OFF(0),
        VIDEO_CLIENT_TURN_FEATURE_ON(1),
        VIDEO_CLIENT_TURN_STATUS_CCP_FAILURE(2);

        private int value;

        private VideoClientTurnStatus(int value) {
            this.value = value;
        }
    }

    public static class AppDetailedInfo {
        private static String UNINITIALIZED;
        private static String appName;
        private static String appVersion;
        private static String deviceModel;
        private static String deviceMake;
        private static final String platformName = "android";
        private static String platformVersion;
        private static String clientSource;
        private static String chimeSdkVersion;

        public static void initialize(String _appName, String _appVersion, String _deviceModel, String _deviceMake, String _platformVersion, String _clientSource, String _chimeSdkVersion) {
            appName = TextUtils.isEmpty((CharSequence)_appName) ? UNINITIALIZED : _appName;
            appVersion = TextUtils.isEmpty((CharSequence)_appVersion) ? UNINITIALIZED : _appVersion;
            deviceModel = TextUtils.isEmpty((CharSequence)_deviceModel) ? UNINITIALIZED : _deviceModel;
            deviceMake = TextUtils.isEmpty((CharSequence)_deviceMake) ? UNINITIALIZED : _deviceMake;
            platformVersion = TextUtils.isEmpty((CharSequence)_platformVersion) ? UNINITIALIZED : _platformVersion;
            clientSource = TextUtils.isEmpty((CharSequence)_clientSource) ? UNINITIALIZED : _clientSource;
            chimeSdkVersion = TextUtils.isEmpty((CharSequence)_chimeSdkVersion) ? UNINITIALIZED : _chimeSdkVersion;
        }

        static {
            appName = UNINITIALIZED = "<uninitialized>";
            appVersion = UNINITIALIZED;
            deviceModel = UNINITIALIZED;
            deviceMake = UNINITIALIZED;
            platformVersion = UNINITIALIZED;
            clientSource = UNINITIALIZED;
            chimeSdkVersion = UNINITIALIZED;
        }
    }
}

