/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.video;

import com.xodee.client.video.VideoFrameRGBABuffer;
import com.xodee.client.video.YuvUtil;
import org.amazon.chime.webrtc.JavaI420Buffer;
import org.amazon.chime.webrtc.VideoFrame;

class VideoFrameRGBABufferAdapter {
    VideoFrameRGBABufferAdapter() {
    }

    public static class MediaToWebRTC
    implements VideoFrame.Buffer {
        private VideoFrameRGBABuffer rgbaBuffer;

        MediaToWebRTC(VideoFrameRGBABuffer rgbaBuffer) {
            this.rgbaBuffer = rgbaBuffer;
        }

        public int getWidth() {
            return this.rgbaBuffer.getWidth();
        }

        public int getHeight() {
            return this.rgbaBuffer.getHeight();
        }

        public VideoFrame.I420Buffer toI420() {
            JavaI420Buffer i420Buffer = JavaI420Buffer.allocate((int)this.getWidth(), (int)this.getHeight());
            YuvUtil.ABGRToI420(this.rgbaBuffer.getData(), this.rgbaBuffer.getStride(), i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), i420Buffer.getWidth(), i420Buffer.getHeight());
            return i420Buffer;
        }

        public void retain() {
            this.rgbaBuffer.retain();
        }

        public void release() {
            this.rgbaBuffer.release();
        }

        public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
            VideoFrame.I420Buffer intermediateBuffer = this.toI420();
            VideoFrame.Buffer modifiedBuffer = intermediateBuffer.cropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight);
            intermediateBuffer.release();
            return modifiedBuffer;
        }
    }
}

