/*
 * Decompiled with CFR 0.152.
 */
package com.biba.screenclient;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.os.Build;
import com.biba.bibacommon.ProxyConfig;
import com.biba.screenclient.ScreenClientCallback;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.amazon.chime.webrtc.Logging;

public class ScreenClientWorker {
    private long nativePeerHandle;
    private static Context context;
    private static final String TAG = "ScreenClientWorker";
    private long callbackNativeGlobalRef;

    private ScreenClientWorker() {
    }

    public static ScreenClientWorker getNewInstance(String profileId, String displayName, String url, String token, ProxyConfig proxyConfig, ScreenClientCallback cb) {
        return ScreenClientWorker.getNewInstance(profileId, displayName, url, token, proxyConfig, cb, null);
    }

    public static ScreenClientWorker getNewInstance(String profileId, String displayName, String url, String token, ProxyConfig proxyConfig, ScreenClientCallback cb, Context ctx) {
        context = ctx;
        ScreenClientWorker w = new ScreenClientWorker();
        int ret = ScreenClientWorker.getNewInstance(w, profileId, displayName, url, token, proxyConfig, cb);
        if (ret != 0) {
            throw new RuntimeException(String.format("Error constructing new Screen Client Worker, returned [%d]", ret));
        }
        return w;
    }

    public static String[] getAvailableDnsServers() {
        if (context == null) {
            Logging.e((String)TAG, (String)"Failed to get active DNS address due to NULL app context");
            return new String[0];
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                LinkProperties linkProperties = mConnectivityManager.getLinkProperties(mConnectivityManager.getActiveNetwork());
                if (linkProperties != null) {
                    List addresses = linkProperties.getDnsServers();
                    ArrayList<String> servers = new ArrayList<String>();
                    for (int i = 0; i < addresses.size(); ++i) {
                        InetAddress addr = (InetAddress)addresses.get(i);
                        Logging.d((String)TAG, (String)("The DNS address is " + addr.getHostAddress()));
                        if (!(addr instanceof Inet4Address)) continue;
                        servers.add(addr.getHostAddress());
                    }
                    return servers.toArray(new String[0]);
                }
            }
            catch (Exception e) {
                Logging.e((String)TAG, (String)("Android Version: " + Build.VERSION.SDK_INT + " failed to get active DNS address: " + e));
            }
        } else {
            try {
                Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
                Method method = SystemProperties.getMethod("get", String.class);
                ArrayList<String> servers = new ArrayList<String>();
                for (String name : new String[]{"net.dns1", "net.dns2"}) {
                    String value = (String)method.invoke(null, name);
                    if (value.isEmpty()) continue;
                    servers.add(value);
                    Logging.d((String)TAG, (String)("The DNS address is " + value));
                }
                return servers.toArray(new String[0]);
            }
            catch (Exception e) {
                Logging.e((String)TAG, (String)("Android Version: " + Build.VERSION.SDK_INT + " failed to get active DNS address: " + e));
            }
        }
        return new String[0];
    }

    private static native int getNewInstance(ScreenClientWorker var0, String var1, String var2, String var3, String var4, ProxyConfig var5, ScreenClientCallback var6);

    public native void destroy();

    public native int start();

    public native int stop();

    public native int view();

    public native int unview();
}

