/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.audio.audioclient;

import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.audio.audioclient.AudioClientSessionConfigBase;

public class AudioClientSessionConfigInternal
extends AudioClientSessionConfigBase {
    private int micCodec;
    private int spkCodec;
    private int sampleRate;
    private int inputChannelCount;
    private int outputChannelCount;
    private int nativeSampleRate;
    private int micMinBufSizeInSamples;
    private int spkMinBufSizeInSamples;
    private int sessionMode;
    private int audioStreamType;

    private AudioClientSessionConfigInternal(AudioClientSessionConfigBase baseConfig, int micCodec, int spkCodec, int sampleRate, int inputChannelCount, int outputChannelCount, int nativeSampleRate, int micMinBufSizeInSamples, int spkMinBufSizeInSamples, int sessionMode, int audioStreamType) {
        super(baseConfig.getTransportMode(), baseConfig.getHost(), baseConfig.getPort(), baseConfig.getSessionToken(), baseConfig.getCallId(), baseConfig.getProfileId(), baseConfig.getMicMute(), baseConfig.getSpkMute(), baseConfig.getPresenter(), baseConfig.getAudioWsUrl(), baseConfig.getProxyConfig(), baseConfig.getAppInfo());
        this.micCodec = micCodec;
        this.spkCodec = spkCodec;
        this.sampleRate = sampleRate;
        this.inputChannelCount = inputChannelCount;
        this.outputChannelCount = outputChannelCount;
        this.nativeSampleRate = nativeSampleRate;
        this.micMinBufSizeInSamples = micMinBufSizeInSamples;
        this.spkMinBufSizeInSamples = spkMinBufSizeInSamples;
        this.sessionMode = sessionMode;
        this.audioStreamType = audioStreamType;
    }

    public int getMicCodec() {
        return this.micCodec;
    }

    public int getSpkCodec() {
        return this.spkCodec;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getInputChannelCount() {
        return this.inputChannelCount;
    }

    public int getOutputChannelCount() {
        return this.outputChannelCount;
    }

    public int getNativeSampleRate() {
        return this.nativeSampleRate;
    }

    public int getMicMinBufSizeInSamples() {
        return this.micMinBufSizeInSamples;
    }

    public int getSpkMinBufSizeInSamples() {
        return this.spkMinBufSizeInSamples;
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public int getAudioStreamType() {
        return this.audioStreamType;
    }

    public static class Builder
    extends AudioClientSessionConfigBase.Builder<Builder> {
        private int micCodec;
        private int spkCodec;
        private int sampleRate;
        private int inputChannelCount;
        private int outputChannelCount;
        private int nativeSampleRate;
        private int micMinBufSizeInSamples;
        private int spkMinBufSizeInSamples;
        private int sessionMode;
        private int audioStreamType;

        public Builder(String host, int port, String sessionToken, String callId, String profileId, String audioWsUrl, AppInfo appInfo, int micCodec, int spkCodec, int sampleRate, int inputChannelCount, int outputChannelCount, int nativeSampleRate, int micMinBufSizeInSamples, int spkMinBufSizeInSamples, int sessionMode, int audioStreamType) {
            super(host, port, sessionToken, callId, profileId, audioWsUrl, appInfo);
            this.micCodec = micCodec;
            this.spkCodec = spkCodec;
            this.sampleRate = sampleRate;
            this.inputChannelCount = inputChannelCount;
            this.outputChannelCount = outputChannelCount;
            this.nativeSampleRate = nativeSampleRate;
            this.micMinBufSizeInSamples = micMinBufSizeInSamples;
            this.spkMinBufSizeInSamples = spkMinBufSizeInSamples;
            this.sessionMode = sessionMode;
            this.audioStreamType = audioStreamType;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder withMicCodec(int micCodec) {
            this.micCodec = micCodec;
            return this;
        }

        public Builder withSpkCodec(int spkCodec) {
            this.spkCodec = spkCodec;
            return this;
        }

        public Builder withSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder withInputChannelCount(int inputChannelCount) {
            this.inputChannelCount = inputChannelCount;
            return this;
        }

        public Builder withOutputChannelCount(int outputChannelCount) {
            this.outputChannelCount = outputChannelCount;
            return this;
        }

        public Builder withNativeSampleRate(int nativeSampleRate) {
            this.nativeSampleRate = nativeSampleRate;
            return this;
        }

        public Builder withMicMinBufSizeInSamples(int micMinBufSizeInSamples) {
            this.micMinBufSizeInSamples = micMinBufSizeInSamples;
            return this;
        }

        public Builder withSpkMinBufSizeInSamples(int spkMinBufSizeInSamples) {
            this.spkMinBufSizeInSamples = spkMinBufSizeInSamples;
            return this;
        }

        public Builder withSessionMode(int sessionMode) {
            this.sessionMode = sessionMode;
            return this;
        }

        public Builder withAudioStreamType(int audioStreamType) {
            this.audioStreamType = audioStreamType;
            return this;
        }

        @Override
        public AudioClientSessionConfigInternal build() {
            return new AudioClientSessionConfigInternal(super.build(), this.micCodec, this.spkCodec, this.sampleRate, this.inputChannelCount, this.outputChannelCount, this.nativeSampleRate, this.micMinBufSizeInSamples, this.spkMinBufSizeInSamples, this.sessionMode, this.audioStreamType);
        }
    }
}

