/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.audio.audioclient;

import com.biba.bibacommon.ProxyConfig;
import com.xodee.client.audio.audioclient.AppInfo;

public class AudioClientSessionConfigBase {
    private int transportMode;
    private String host;
    private int port;
    private String sessionToken;
    private String callId;
    private String profileId;
    private boolean micMute;
    private boolean spkMute;
    private boolean presenter;
    private String audioWsUrl;
    private ProxyConfig proxyConfig;
    private AppInfo appInfo;

    protected AudioClientSessionConfigBase() {
    }

    protected AudioClientSessionConfigBase(int transportMode, String host, int port, String sessionToken, String callId, String profileId, boolean micMute, boolean spkMute, boolean presenter, String audioWsUrl, ProxyConfig proxyConfig, AppInfo appInfo) {
        this.transportMode = transportMode;
        this.host = host;
        this.port = port;
        this.sessionToken = sessionToken;
        this.callId = callId;
        this.profileId = profileId;
        this.micMute = micMute;
        this.spkMute = spkMute;
        this.presenter = presenter;
        this.audioWsUrl = audioWsUrl;
        this.proxyConfig = proxyConfig;
        this.appInfo = appInfo;
    }

    public int getTransportMode() {
        return this.transportMode;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean getMicMute() {
        return this.micMute;
    }

    public boolean getSpkMute() {
        return this.spkMute;
    }

    public boolean getPresenter() {
        return this.presenter;
    }

    public String getAudioWsUrl() {
        return this.audioWsUrl;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    protected static abstract class Builder<B extends Builder> {
        private int transportMode = 3;
        private boolean presenter = true;
        private boolean micMute = false;
        private boolean spkMute = false;
        private ProxyConfig proxyConfig = null;
        private String host;
        private int port;
        private String sessionToken;
        private String callId;
        private String profileId;
        private String audioWsUrl;
        private AppInfo appInfo;

        protected Builder(String host, int port, String sessionToken, String callId, String profileId, String audioWsUrl, AppInfo appInfo) {
            this.host = host;
            this.port = port;
            this.sessionToken = sessionToken;
            this.callId = callId;
            this.profileId = profileId;
            this.audioWsUrl = audioWsUrl;
            this.appInfo = appInfo;
        }

        protected abstract B self();

        public B withTransportMode(int transportMode) {
            this.transportMode = transportMode;
            return this.self();
        }

        public B withPresenter(boolean presenter) {
            this.presenter = presenter;
            return this.self();
        }

        public B withMicMute(boolean micMute) {
            this.micMute = micMute;
            return this.self();
        }

        public B withSpkMute(boolean spkMute) {
            this.spkMute = spkMute;
            return this.self();
        }

        public B withProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this.self();
        }

        public B withHost(String host) {
            this.host = host;
            return this.self();
        }

        public B withPort(int port) {
            this.port = port;
            return this.self();
        }

        public B withSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this.self();
        }

        public B withCallId(String callId) {
            this.callId = callId;
            return this.self();
        }

        public B withProfileId(String profileId) {
            this.profileId = profileId;
            return this.self();
        }

        public B withAudioWsUrl(String audioWsUrl) {
            this.audioWsUrl = audioWsUrl;
            return this.self();
        }

        public B withAppInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            return this.self();
        }

        public AudioClientSessionConfigBase build() {
            return new AudioClientSessionConfigBase(this.transportMode, this.host, this.port, this.sessionToken, this.callId, this.profileId, this.micMute, this.spkMute, this.presenter, this.audioWsUrl, this.proxyConfig, this.appInfo);
        }
    }
}

