/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.video;

import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import com.xodee.client.video.VideoFrame;
import com.xodee.client.video.VideoSink;
import com.xodee.client.video.VideoSource;
import org.amazon.chime.webrtc.CapturerObserver;
import org.amazon.chime.webrtc.EglBase;
import org.amazon.chime.webrtc.YuvConverter;

public class VideoSourceAdapter
implements VideoSink {
    private CapturerObserver captureObserver;
    private YuvConverter yuvConverter = new YuvConverter();
    private VideoSource source;
    private final Handler handler;
    private EglBase eglBase;

    VideoSourceAdapter(CapturerObserver captureObserver, EGLContext sharedContext) {
        this.captureObserver = captureObserver;
        HandlerThread thread = new HandlerThread("Media.VideoSourceAdapter");
        thread.start();
        this.handler = new Handler(thread.getLooper());
        this.handler.post(() -> {
            this.eglBase = EglBase.createEgl14((EGLContext)sharedContext, (int[])EglBase.CONFIG_PIXEL_BUFFER);
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        });
    }

    public void release() {
        this.handler.post(() -> {
            this.yuvConverter.release();
            this.eglBase.release();
            this.handler.getLooper().quit();
        });
    }

    public void setSource(VideoSource newSource) {
        if (this.source != null) {
            this.source.removeSink(this);
        }
        newSource.addSink(this);
        this.source = newSource;
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        this.captureObserver.onFrameCaptured(frame.toWebRTCVideoFrame(this.handler, this.yuvConverter));
    }
}

