/*
 * Decompiled with CFR 0.152.
 */
package com.xodee.client.audio.audioclient;

import android.content.res.AssetManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.util.Log;
import com.biba.bibacommon.ProxyConfig;
import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.audio.audioclient.AttendeeUpdate;
import com.xodee.client.audio.audioclient.AudioClientException;
import com.xodee.client.audio.audioclient.AudioClientLogListener;
import com.xodee.client.audio.audioclient.AudioClientMetricsListener;
import com.xodee.client.audio.audioclient.AudioClientPresenceListener;
import com.xodee.client.audio.audioclient.AudioClientPrimaryMeetingEventListener;
import com.xodee.client.audio.audioclient.AudioClientSignalStrengthChangeListener;
import com.xodee.client.audio.audioclient.AudioClientStateChangeListener;
import com.xodee.client.audio.audioclient.AudioClientTranscriptEventsListener;
import com.xodee.client.audio.audioclient.AudioClientVolumeStateChangeListener;
import com.xodee.client.audio.audioclient.transcript.TranscriptEvent;

public class AudioClient {
    public static final int XTL_CONNECTION_TYPE_SPK = 1;
    public static final int XTL_CONNECTION_TYPE_MIC = 2;
    public static final int XTL_TRANSPORT_WEBSOCKET = 1;
    public static final int XTL_TRANSPORT_UDP = 2;
    public static final int XTL_TRANSPORT_DTLS = 3;
    public static final int XTL_TRANSPORT_WEBSOCKET_SSL = 4;
    public static final int XTL_DEFAULT_TRANSPORT = 3;
    public static final int SPK_STREAM_ROUTE_UNKNOWN = -1;
    public static final int SPK_STREAM_ROUTE_RECEIVER = 0;
    public static final int SPK_STREAM_ROUTE_HEADSET = 1;
    public static final int SPK_STREAM_ROUTE_SPEAKER = 2;
    public static final int SPK_STREAM_ROUTE_BT_AUDIO = 3;
    public static final int OPENSL_MIC_DEFAULT = 1;
    public static final int OPENSL_MIC_CAMCORDER = 2;
    public static final int kCodecMuLaw16KHz = 1;
    public static final int kCodecPCM16KHz16bit = 2;
    public static final int kCodecPCM8KHz16bit = 3;
    public static final int kCodecSpeexNarrowband = 4;
    public static final int kCodecSpeexWideband = 5;
    public static final int kCodecOpusLow = 6;
    public static final int kCodecOpusMedium = 7;
    public static final int kCodecOpusHigh = 8;
    public static final int kCodecMuLaw8KHz = 9;
    public static final int kCodecG722 = 10;
    public static final int kCodecOpus48KHz = 11;
    public static final int kAudioCueOthersJoined = 0;
    public static final int kAudioCueOthersLeft = 1;
    public static final int kAudioCueReconnecting = 2;
    public static final int kAudioCueReconnected = 3;
    public static final int kAudioCueReconnectFailed = 4;
    public static final int kAudioCueFirstCaller = 6;
    public static final int kAudioCueMuted = 7;
    public static final int L_VERBOSE = 1;
    public static final int L_DEBUG = 2;
    public static final int L_INFO = 3;
    public static final int L_WARNING = 4;
    public static final int L_ERROR = 5;
    public static final int L_FATAL = 6;
    public static final int AUDIO_CLIENT_SAMPLE_RATE = 16000;
    public static final int INPUT_CHANNEL_COUNT = 1;
    public static final int OUTPUT_CHANNEL_COUNT = 1;
    public static final int SIGNAL_STRENGTH_NO_SIGNAL = 0;
    public static final int SIGNAL_STRENGTH_WEAK_SIGNAL = 1;
    public static final int SIGNAL_STRENGTH_GOOD_SIGNAL = 2;
    public static final int AUDIO_CLIENT_STATE_UNKNOWN = -1;
    public static final int AUDIO_CLIENT_STATE_INIT = 0;
    public static final int AUDIO_CLIENT_STATE_CONNECTING = 1;
    public static final int AUDIO_CLIENT_STATE_CONNECTED = 2;
    public static final int AUDIO_CLIENT_STATE_RECONNECTING = 3;
    public static final int AUDIO_CLIENT_STATE_FAILED_TO_CONNECT = 4;
    public static final int AUDIO_CLIENT_STATE_DISCONNECTING = 5;
    public static final int AUDIO_CLIENT_STATE_DISCONNECTED_NORMAL = 6;
    public static final int AUDIO_CLIENT_STATE_DISCONNECTED_ABNORMAL = 7;
    public static final int AUDIO_CLIENT_STATE_SERVER_HUNGUP = 8;
    public static final int AUDIO_CLIENT_OK = 0;
    public static final int AUDIO_CLIENT_ERR_UNIMPLEMENTED = 23;
    public static final int AUDIO_CLIENT_ERR_INVALID_PARAMETER = 37;
    public static final int AUDIO_CLIENT_STATUS_NETWORK_IS_NOT_GOOD_ENOUGH_FOR_VOIP = 59;
    public static final int AUDIO_CLIENT_ERR_SERVER_HUNGUP = 60;
    public static final int AUDIO_CLIENT_ERR_JOINED_FROM_ANOTHER_DEVICE = 61;
    public static final int AUDIO_CLIENT_ERR_INTERNAL_SERVER_ERROR = 62;
    public static final int AUDIO_CLIENT_ERR_AUTH_REJECTED = 63;
    public static final int AUDIO_CLIENT_ERR_CALL_AT_CAPACITY = 64;
    public static final int AUDIO_CLIENT_ERR_SERVICE_UNAVAILABLE = 65;
    public static final int AUDIO_CLIENT_ERR_START_AUDIO = 67;
    public static final int AUDIO_CLIENT_ERR_SHOULD_DISCONNECT_AUDIO = 69;
    public static final int AUDIO_CLIENT_ERR_CALL_ENDED = 75;
    public static final int AUDIO_CLIENT_ERR_PROXY_AUTHENTICATION_FAILED = 76;
    public static final int AUDIO_CLIENT_ERR_INPUT_DEVICE_NOT_RESPONDING = 82;
    public static final int AUDIO_CLIENT_ERR_OUTPUT_DEVICE_NOT_RESPONDING = 83;
    public static final int CVP_MODULE_NONE = 0;
    public static final int CVP_MODULE_SUBBAND_AEC = 1;
    public static final int CVP_MODULE_NOISE_SUPPRESSOR = 2;
    public static final int CVP_MODULE_HALF_DUPLEX = 4;
    public static final int CVP_MODULE_GAIN_CONTROL = 8;
    public static final int CVP_MODULE_DELAY_ESTIMATOR_V2 = 16;
    public static final int CVP_MODULE_DEBUG_RECORDING = 32;
    public static final int CVP_MODULE_SUBBAND_NLP = 64;
    public static final int CVP_MODULE_DELAY_ESTIMATOR_IMPROVEMENT = 128;
    public static final int CVP_MODULE_SUBBAND_AEC_IMPROVEMENT = 256;
    public static final int CVP_MODULE_BEETHOVEN_NS = 512;
    public static final int CVP_MODULE_XVP_OWN_THREAD = 1024;
    public static final int CVP_MODULE_DISABLE_SPEAKER_ATTENUATION = 2048;
    public static final int CVP_PREF_NONE = 0;
    public static final int CVP_PREF_AUTOGAIN_OFF = 1;
    public static final int AUDIO_CLIENT_METRIC_MIC_DEVICE_FRAMES_LOST_PERCENT = 0;
    public static final int AUDIO_SERVER_METRIC_PRE_JB_MIC_PACKETS_LOST_PERCENT = 1;
    public static final int AUDIO_SERVER_METRIC_MIC_MAX_JITTER_MS = 2;
    public static final int AUDIO_SERVER_METRIC_POST_JB_MIC_1S_PACKETS_LOST_PERCENT = 3;
    public static final int AUDIO_SERVER_METRIC_POST_JB_MIC_5S_PACKETS_LOST_PERCENT = 4;
    public static final int AUDIO_CLIENT_METRIC_PRE_JB_SPK_PACKETS_LOST_PERCENT = 5;
    public static final int AUDIO_CLIENT_METRIC_SPK_MAX_JITTER_MS = 6;
    public static final int AUDIO_CLIENT_METRIC_POST_JB_SPK_1S_PACKETS_LOST_PERCENT = 7;
    public static final int AUDIO_CLIENT_METRIC_POST_JB_SPK_5S_PACKETS_LOST_PERCENT = 8;
    public static final int AUDIO_CLIENT_PRIMARY_MEETING_NONE = 0;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_JOIN_ACK = 1;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_LEAVE = 2;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_LEAVE_ACK = 3;
    public static final int AUDIO_CLIENT_PRIMARY_MEETING_OK = 0;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_AT_CAPACITY = 1;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_AUTHENTICATION_FAILED = 2;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_DISCONNECTED = 3;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_REMOVED_FROM_MEETING = 4;
    public static final int AUDIO_SERVER_PRIMARY_MEETING_INTERNAL_ERROR = 5;
    private long peer;
    private int audioClientState = 0;
    private AudioClientStateChangeListener audioClientStateListener;
    private AudioClientVolumeStateChangeListener volumeStateListener;
    private AudioClientSignalStrengthChangeListener signalStrengthListener;
    private AudioClientLogListener logListener;
    private AudioClientMetricsListener metricsListener;
    private AudioClientPresenceListener presenceListener;
    private AudioClientTranscriptEventsListener transcriptEventsListener;
    private AudioClientPrimaryMeetingEventListener primaryMeetingEventListener;
    private static final String TAG = "AudioClient";
    public static final int MESS_BOUNCE = 1;
    public static final int MESS_SET_MIC_FRAMES_PER_BUFFER = 2;
    public static final int MESS_SET_SPK_FRAMES_PER_BUFFER = 3;
    public static final int MESS_SET_HARDWARE_SAMPLE_RATE = 4;
    public static final int MESS_SET_IO_SAMPLE_RATE = 5;
    public static final int MESS_SET_SPEAKERPHONE_MIC = 6;
    public static final int MESS_SET_CVP_MODULE_FLAG = 7;
    public static final int MESS_SET_CVP_PREF_FLAG = 8;

    public static String CODEC_TO_STRING(int codec) {
        switch (codec) {
            case 1: {
                return "\u03bc-law";
            }
            case 2: {
                return "PCM 16k";
            }
            case 3: {
                return "PCM 8K";
            }
            case 4: {
                return "Speex Narrowband";
            }
            case 5: {
                return "Speex Wideband";
            }
            case 6: {
                return "Opus Low-Complexity";
            }
            case 7: {
                return "Opus Medium-Complexity";
            }
            case 8: {
                return "Opus High-Complexity";
            }
        }
        return "Unknown codec";
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "Inactive";
            }
            case 1: {
                return "Connecting";
            }
            case 2: {
                return "Connected";
            }
            case 3: {
                return "Reconnecting";
            }
            case 4: {
                return "Failed to Connect";
            }
            case 6: {
                return "Disconnected";
            }
            case 7: {
                return "Failed";
            }
            case 8: {
                return "Server Hungup";
            }
        }
        return "Unknown";
    }

    public AudioClient() throws AudioClientException {
        this(null, new AudioClientStateChangeListener(){

            @Override
            public void onAudioClientStateChange(int state, int status) {
                Log.d((String)AudioClient.TAG, (String)("CALL STREAM STATE CHANGED TO " + AudioClient.stateToString(state)));
            }
        }, new AudioClientVolumeStateChangeListener(){

            @Override
            public void onVolumeStateChange(AttendeeUpdate[] attendeeUpdates) {
                for (AttendeeUpdate attendeeUpdate : attendeeUpdates) {
                    Log.d((String)AudioClient.TAG, (String)String.format("Profile id: %s, volume level: %s", attendeeUpdate.getProfileId(), attendeeUpdate.getData()));
                }
            }
        }, new AudioClientSignalStrengthChangeListener(){

            @Override
            public void onSignalStrengthChange(AttendeeUpdate[] attendeeUpdates) {
                for (AttendeeUpdate attendeeUpdate : attendeeUpdates) {
                    Log.d((String)AudioClient.TAG, (String)String.format("Profile id: %s, signal strength: %s", attendeeUpdate.getProfileId(), attendeeUpdate.getData()));
                }
            }
        }, new AudioClientLogListener(){

            @Override
            public void onLogMessage(int logLevel, String message) {
                Log.d((String)AudioClient.TAG, (String)("log level: " + logLevel + " message: " + message));
            }
        }, new AudioClientMetricsListener(){

            @Override
            public void onMetrics(int[] metrics, double[] values) {
                Log.d((String)AudioClient.TAG, (String)("Metrics: " + metrics + " values: " + values));
            }
        }, new AudioClientPresenceListener(){

            @Override
            public void onAttendeesPresenceChange(AttendeeUpdate[] attendeeUpdates) {
                for (AttendeeUpdate attendeeUpdate : attendeeUpdates) {
                    Log.d((String)AudioClient.TAG, (String)String.format("Profile id: %s, presence state: %s", attendeeUpdate.getProfileId(), attendeeUpdate.getData()));
                }
            }
        }, new AudioClientTranscriptEventsListener(){

            @Override
            public void onTranscriptEventsReceived(TranscriptEvent[] events) {
                for (TranscriptEvent event : events) {
                    Log.d((String)AudioClient.TAG, (String)String.format("Transcript event type: %s", event.getClass()));
                }
            }
        }, new AudioClientPrimaryMeetingEventListener(){

            @Override
            public void onAudioClientPrimaryMeetingEvent(int type, int status) {
                Log.d((String)AudioClient.TAG, (String)("Primary meeting event type:" + type + " status:" + status));
            }
        }, 0L);
    }

    public AudioClient(AssetManager assman, AudioClientStateChangeListener audioClientStateListener, AudioClientVolumeStateChangeListener volumeStateListener, AudioClientSignalStrengthChangeListener signalStrengthListener, AudioClientLogListener logListener, AudioClientMetricsListener metricsListener, AudioClientPresenceListener presenceListener, AudioClientTranscriptEventsListener transcriptEventsListener, AudioClientPrimaryMeetingEventListener primaryMeetingEventListener, long analyticsRef) throws AudioClientException {
        this.audioClientStateListener = audioClientStateListener;
        this.volumeStateListener = volumeStateListener;
        this.signalStrengthListener = signalStrengthListener;
        this.logListener = logListener;
        this.metricsListener = metricsListener;
        this.presenceListener = presenceListener;
        this.transcriptEventsListener = transcriptEventsListener;
        this.primaryMeetingEventListener = primaryMeetingEventListener;
        int res = this.initNative(assman, analyticsRef);
        if (res != 0) {
            throw new AudioClientException("Unable to initialize Audio Client. res=" + res);
        }
        int channel_config = 4;
        int spkMinBufSizeInBytes = AudioTrack.getMinBufferSize((int)16000, (int)4, (int)2);
        int micMinBufSizeInBytes = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
        float spkLatMs = (float)spkMinBufSizeInBytes / 2.0f / 16000.0f * 1000.0f;
        float micLatMs = (float)micMinBufSizeInBytes / 2.0f / 16000.0f * 1000.0f;
        Log.i((String)TAG, (String)("SPK LAT: " + spkLatMs + "(ms) MIC LAT: " + micLatMs + "(ms)"));
        int nativeSR = AudioTrack.getNativeOutputSampleRate((int)1);
        spkMinBufSizeInBytes = AudioTrack.getMinBufferSize((int)nativeSR, (int)4, (int)2);
        micMinBufSizeInBytes = AudioRecord.getMinBufferSize((int)nativeSR, (int)16, (int)2);
        spkLatMs = (float)spkMinBufSizeInBytes / 2.0f / (float)nativeSR * 1000.0f;
        micLatMs = (float)micMinBufSizeInBytes / 2.0f / (float)nativeSR * 1000.0f;
        Log.i((String)TAG, (String)("SPK LAT: " + spkLatMs + "(ms) MIC LAT: " + micLatMs + "(ms) NATIVE SR: " + nativeSR));
    }

    public int startSession(int transportMode, String host, int port, String sessionToken, String callId, String profileId, int micCodec, int spkCodec, boolean micMute, boolean spkMute, boolean presenter, String audioWsUrl, ProxyConfig proxyConfig) {
        return this.doStartSession(transportMode, host, port, sessionToken, callId, profileId, micCodec, spkCodec, micMute, spkMute, presenter, audioWsUrl, proxyConfig, 16000, 1, 1);
    }

    public int startSession(int transportMode, String host, int port, String sessionToken, String callId, String profileId, int micCodec, int spkCodec, boolean micMute, boolean spkMute, boolean presenter, String audioWsUrl, ProxyConfig proxyConfig, int sample_rate, int input_channel_count, int output_channel_count) {
        return this.doStartSession(transportMode, host, port, sessionToken, callId, profileId, micCodec, spkCodec, micMute, spkMute, presenter, audioWsUrl, proxyConfig, sample_rate, input_channel_count, output_channel_count);
    }

    public int startSessionV2(int transportMode, String host, int port, String sessionToken, String callId, String profileId, int micCodec, int spkCodec, boolean micMute, boolean spkMute, boolean presenter, String audioWsUrl, ProxyConfig proxyConfig, AppInfo appInfo) {
        int nativeSampleRate = AudioTrack.getNativeOutputSampleRate((int)1);
        int spkMinBufSizeInSamples = AudioTrack.getMinBufferSize((int)nativeSampleRate, (int)4, (int)2) / 2;
        int micMinBufSizeInSamples = AudioRecord.getMinBufferSize((int)nativeSampleRate, (int)16, (int)2) / 2;
        return this.doStartSessionV2(transportMode, host, port, sessionToken, callId, profileId, micCodec, spkCodec, micMute, spkMute, presenter, audioWsUrl, proxyConfig, appInfo, 16000, 1, 1, nativeSampleRate, micMinBufSizeInSamples, spkMinBufSizeInSamples, AudioSessionMode.AUDIO_SESSION_WITH_AUDIO.ordinal());
    }

    public int startSessionV2(int transportMode, String host, int port, String sessionToken, String callId, String profileId, boolean micMute, boolean spkMute, boolean presenter, String audioWsUrl, ProxyConfig proxyConfig, AppInfo appInfo, AudioModeInternal audioMode) {
        int sampleRate = 16000;
        int outputChannelCount = 1;
        int inputChannelCount = 1;
        int codecMode = 6;
        int spkChannelConfig = 4;
        int sessionMode = AudioSessionMode.AUDIO_SESSION_WITH_AUDIO.ordinal();
        switch (audioMode) {
            case NO_AUDIO: {
                sessionMode = AudioSessionMode.AUDIO_SESSION_CHECKED_IN.ordinal();
                micMute = true;
                spkMute = true;
                break;
            }
            case MONO_16K: {
                break;
            }
            case MONO_48K: {
                sampleRate = 48000;
                codecMode = 11;
                break;
            }
            case STEREO_48K: {
                sampleRate = 48000;
                outputChannelCount = 2;
                codecMode = 11;
                spkChannelConfig = 12;
                break;
            }
            case NO_DEVICE: {
                sessionMode = AudioSessionMode.AUDIO_SESSION_NO_DEVICE.ordinal();
                micMute = true;
                spkMute = false;
                break;
            }
            default: {
                return 37;
            }
        }
        int nativeSampleRate = AudioTrack.getNativeOutputSampleRate((int)1);
        int spkMinBufSizeInSamples = AudioTrack.getMinBufferSize((int)nativeSampleRate, (int)spkChannelConfig, (int)2) / 2;
        int micMinBufSizeInSamples = AudioRecord.getMinBufferSize((int)nativeSampleRate, (int)16, (int)2) / 2;
        return this.doStartSessionV2(transportMode, host, port, sessionToken, callId, profileId, codecMode, codecMode, micMute, spkMute, presenter, audioWsUrl, proxyConfig, appInfo, sampleRate, inputChannelCount, outputChannelCount, nativeSampleRate, micMinBufSizeInSamples, spkMinBufSizeInSamples, sessionMode);
    }

    public int stopSession() {
        return this.doStopSession();
    }

    public int setMicStreamCodec(int codec) {
        return this.doSetMicStreamCodec(codec);
    }

    public int setSpeakerStreamCodec(int codec) {
        return this.doSetSpeakerStreamCodec(codec);
    }

    public int setRoute(int route) {
        return this.doSetRoute(route);
    }

    public int getRoute() {
        return this.doGetRoute();
    }

    public int setVoiceFocusNoiseSuppression(boolean b) {
        return this.doSetVoiceFocusNoiseSuppression(b);
    }

    public boolean getVoiceFocusNoiseSuppression() {
        return this.doGetVoiceFocusNoiseSuppression();
    }

    public int setMicMute(boolean b) {
        return this.doSetMicMute(b);
    }

    public boolean getMicMute() {
        return this.doGetMicMute();
    }

    public int stopAudioRecord() {
        return this.doStopAudioRecord();
    }

    public void setPresenter(boolean p) {
        this.doSetPresenter(p);
    }

    public int preloadAudioCues() {
        return this.doPreloadAudioCues();
    }

    public int playCue(int cueid, boolean loop, boolean retrigger) {
        return this.doPlayCue(cueid, loop, retrigger);
    }

    public int stopCue(int cueid) {
        return this.doStopCue(cueid);
    }

    public int sendMessage(int mess, int arg) {
        return this.doNotify(mess, arg);
    }

    public int sendMessage(int mess) {
        return this.doNotify(mess, -1);
    }

    public void promoteToPrimaryMeeting(String attendeeId, String externalUserId, String sessionToken) {
        this.doPromoteToPrimaryMeeting(attendeeId, externalUserId, sessionToken);
    }

    public void demoteFromPrimaryMeeting() {
        this.doDemoteFromPrimaryMeeting();
    }

    private native int initNative(AssetManager var1, long var2);

    protected native int doStartSession(int var1, String var2, int var3, String var4, String var5, String var6, int var7, int var8, boolean var9, boolean var10, boolean var11, String var12, ProxyConfig var13, int var14, int var15, int var16);

    protected native int doStartSessionV2(int var1, String var2, int var3, String var4, String var5, String var6, int var7, int var8, boolean var9, boolean var10, boolean var11, String var12, ProxyConfig var13, AppInfo var14, int var15, int var16, int var17, int var18, int var19, int var20, int var21);

    protected native int doStopSession();

    protected native int doSetMicStreamCodec(int var1);

    protected native int doSetSpeakerStreamCodec(int var1);

    protected native int doSetRoute(int var1);

    protected native int doGetRoute();

    protected native int doNotify(int var1, int var2);

    protected native int doSetVoiceFocusNoiseSuppression(boolean var1);

    protected native boolean doGetVoiceFocusNoiseSuppression();

    protected native int doSetMicMute(boolean var1);

    protected native boolean doGetMicMute();

    protected native int doStopAudioRecord();

    protected native void doSetPresenter(boolean var1);

    protected native int doPreloadAudioCues();

    protected native int doPlayCue(int var1, boolean var2, boolean var3);

    protected native int doStopCue(int var1);

    private native void doPromoteToPrimaryMeeting(String var1, String var2, String var3);

    private native void doDemoteFromPrimaryMeeting();

    public native void release();

    static {
        Log.d((String)TAG, (String)"[AudioClient.java] break here");
    }

    public static enum AudioSessionMode {
        AUDIO_SESSION_WITH_AUDIO,
        AUDIO_SESSION_CHECKED_IN,
        AUDIO_SESSION_NO_DEVICE;

    }

    public static enum AudioModeInternal {
        NO_AUDIO,
        MONO_16K,
        MONO_48K,
        STEREO_48K,
        NO_DEVICE;

    }
}

