/*
 * Decompiled with CFR 0.152.
 */
package software.aws.awsprototypingsdk.nxmonorepo;

import io.github.cdklabs.projen.Component;
import io.github.cdklabs.projen.Project;
import io.github.cdklabs.projen.Task;
import io.github.cdklabs.projen.java.JavaProject;
import io.github.cdklabs.projen.python.PythonProject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.aws.awsprototypingsdk.nxmonorepo.$Module;
import software.aws.awsprototypingsdk.nxmonorepo.INxProjectCore;
import software.aws.awsprototypingsdk.nxmonorepo.NxConfiguratorOptions;
import software.aws.awsprototypingsdk.nxmonorepo.NxWorkspace;
import software.aws.awsprototypingsdk.nxmonorepo.nx.RunManyOptions;

@Jsii(module=$Module.class, fqn="@aws-prototyping-sdk/nx-monorepo.NxConfigurator")
public class NxConfigurator
extends Component
implements INxProjectCore {
    protected NxConfigurator(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NxConfigurator(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NxConfigurator(@NotNull Project project, @Nullable NxConfiguratorOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required"), options});
    }

    public NxConfigurator(@NotNull Project project) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(project, "project is required")});
    }

    @Override
    public void addImplicitDependency(@NotNull Project dependent, @NotNull Object dependee) {
        if (Configuration.getRuntimeTypeChecking() && !(dependee instanceof String) && !(dependee instanceof Project)) {
            throw new IllegalArgumentException("Expected " + "dependee" + " to be one of: java.lang.String, io.github.cdklabs.projen.Project; received " + dependee.getClass());
        }
        Kernel.call((Object)this, (String)"addImplicitDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(dependent, "dependent is required"), Objects.requireNonNull(dependee, "dependee is required")});
    }

    @Override
    public void addJavaDependency(@NotNull JavaProject dependent, @NotNull JavaProject dependee) {
        Kernel.call((Object)this, (String)"addJavaDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(dependent, "dependent is required"), Objects.requireNonNull(dependee, "dependee is required")});
    }

    @Override
    @NotNull
    public Task addNxRunManyTask(@NotNull String name, @NotNull RunManyOptions options) {
        return (Task)Kernel.call((Object)this, (String)"addNxRunManyTask", (NativeType)NativeType.forClass(Task.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void addPythonPoetryDependency(@NotNull PythonProject dependent, @NotNull PythonProject dependee) {
        Kernel.call((Object)this, (String)"addPythonPoetryDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(dependent, "dependent is required"), Objects.requireNonNull(dependee, "dependee is required")});
    }

    @Override
    @NotNull
    public List<String> composeNxRunManyCommand(@NotNull RunManyOptions options) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"composeNxRunManyCommand", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")}));
    }

    @NotNull
    public Task ensureNxInstallTask(String ... nxPlugins) {
        return (Task)Kernel.call((Object)this, (String)"ensureNxInstallTask", (NativeType)NativeType.forClass(Task.class), (Object[])Arrays.stream(nxPlugins).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public String execNxRunManyCommand(@NotNull RunManyOptions options) {
        return (String)Kernel.call((Object)this, (String)"execNxRunManyCommand", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    public void preSynthesize() {
        Kernel.call((Object)this, (String)"preSynthesize", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void synth() {
        Kernel.call((Object)this, (String)"synth", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public NxWorkspace getNx() {
        return (NxWorkspace)((Object)Kernel.get((Object)this, (String)"nx", (NativeType)NativeType.forClass(NxWorkspace.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NxConfigurator> {
        private final Project project;
        private NxConfiguratorOptions.Builder options;

        public static Builder create(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            this.project = project;
        }

        public Builder defaultReleaseBranch(String defaultReleaseBranch) {
            this.options().defaultReleaseBranch(defaultReleaseBranch);
            return this;
        }

        public NxConfigurator build() {
            return new NxConfigurator(this.project, this.options != null ? this.options.build() : null);
        }

        private NxConfiguratorOptions.Builder options() {
            if (this.options == null) {
                this.options = new NxConfiguratorOptions.Builder();
            }
            return this.options;
        }
    }
}

