/*
 * Decompiled with CFR 0.152.
 */
package software.aws.awsprototypingsdk.cdkgraph.graph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.aws.awsprototypingsdk.cdkgraph.$Module;
import software.aws.awsprototypingsdk.cdkgraph.graph.Edge;
import software.aws.awsprototypingsdk.cdkgraph.graph.IStoreCounts;
import software.aws.awsprototypingsdk.cdkgraph.graph.Node;
import software.aws.awsprototypingsdk.cdkgraph.graph.RootNode;
import software.aws.awsprototypingsdk.cdkgraph.graph.StackNode;
import software.aws.awsprototypingsdk.cdkgraph.graph.StageNode;
import software.aws.awsprototypingsdk.cdkgraph.serialized_graph.GraphStore;
import software.aws.awsprototypingsdk.cdkgraph.serialized_graph.ISerializableGraphStore;

@Jsii(module=$Module.class, fqn="@aws-prototyping-sdk/cdk-graph.Graph.Store")
public class Store
extends JsiiObject
implements ISerializableGraphStore {
    protected Store(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Store(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Store(@Nullable Boolean allowDestructiveMutations) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{allowDestructiveMutations});
    }

    public Store() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static Store fromSerializedStore(@NotNull GraphStore serializedStore) {
        return (Store)JsiiObject.jsiiStaticCall(Store.class, (String)"fromSerializedStore", (NativeType)NativeType.forClass(Store.class), (Object[])new Object[]{Objects.requireNonNull(serializedStore, "serializedStore is required")});
    }

    public void addEdge(@NotNull Edge edge) {
        Kernel.call((Object)this, (String)"addEdge", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(edge, "edge is required")});
    }

    public void addNode(@NotNull Node node) {
        Kernel.call((Object)this, (String)"addNode", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public void addStack(@NotNull StackNode stack) {
        Kernel.call((Object)this, (String)"addStack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required")});
    }

    public void addStage(@NotNull StageNode stage) {
        Kernel.call((Object)this, (String)"addStage", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Store clone(@Nullable Boolean allowDestructiveMutations) {
        return (Store)Kernel.call((Object)this, (String)"clone", (NativeType)NativeType.forClass(Store.class), (Object[])new Object[]{allowDestructiveMutations});
    }

    @NotNull
    public Store clone() {
        return (Store)Kernel.call((Object)this, (String)"clone", (NativeType)NativeType.forClass(Store.class), (Object[])new Object[0]);
    }

    @NotNull
    public String computeLogicalUniversalId(@NotNull StackNode stack, @NotNull String logicalId) {
        return (String)Kernel.call((Object)this, (String)"computeLogicalUniversalId", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required"), Objects.requireNonNull(logicalId, "logicalId is required")});
    }

    @NotNull
    public Node findNodeByLogicalId(@NotNull StackNode stack, @NotNull String logicalId) {
        return (Node)Kernel.call((Object)this, (String)"findNodeByLogicalId", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required"), Objects.requireNonNull(logicalId, "logicalId is required")});
    }

    @NotNull
    public Node findNodeByLogicalUniversalId(@NotNull String uid) {
        return (Node)Kernel.call((Object)this, (String)"findNodeByLogicalUniversalId", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(uid, "uid is required")});
    }

    @NotNull
    public Edge getEdge(@NotNull String uuid) {
        return (Edge)Kernel.call((Object)this, (String)"getEdge", (NativeType)NativeType.forClass(Edge.class), (Object[])new Object[]{Objects.requireNonNull(uuid, "uuid is required")});
    }

    @NotNull
    public Node getNode(@NotNull String uuid) {
        return (Node)Kernel.call((Object)this, (String)"getNode", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(uuid, "uuid is required")});
    }

    @NotNull
    public StackNode getStack(@NotNull String uuid) {
        return (StackNode)Kernel.call((Object)this, (String)"getStack", (NativeType)NativeType.forClass(StackNode.class), (Object[])new Object[]{Objects.requireNonNull(uuid, "uuid is required")});
    }

    @NotNull
    public StageNode getStage(@NotNull String uuid) {
        return (StageNode)Kernel.call((Object)this, (String)"getStage", (NativeType)NativeType.forClass(StageNode.class), (Object[])new Object[]{Objects.requireNonNull(uuid, "uuid is required")});
    }

    @NotNull
    public Boolean mutateRemoveEdge(@NotNull Edge edge) {
        return (Boolean)Kernel.call((Object)this, (String)"mutateRemoveEdge", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(edge, "edge is required")});
    }

    @NotNull
    public Boolean mutateRemoveNode(@NotNull Node node) {
        return (Boolean)Kernel.call((Object)this, (String)"mutateRemoveNode", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public void recordLogicalId(@NotNull StackNode stack, @NotNull String logicalId, @NotNull Node resource) {
        Kernel.call((Object)this, (String)"recordLogicalId", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stack, "stack is required"), Objects.requireNonNull(logicalId, "logicalId is required"), Objects.requireNonNull(resource, "resource is required")});
    }

    @Override
    @NotNull
    public GraphStore serialize() {
        return (GraphStore)Kernel.call((Object)this, (String)"serialize", (NativeType)NativeType.forClass(GraphStore.class), (Object[])new Object[0]);
    }

    public void verifyDestructiveMutationAllowed() {
        Kernel.call((Object)this, (String)"verifyDestructiveMutationAllowed", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public Boolean getAllowDestructiveMutations() {
        return (Boolean)Kernel.get((Object)this, (String)"allowDestructiveMutations", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public IStoreCounts getCounts() {
        return (IStoreCounts)Kernel.get((Object)this, (String)"counts", (NativeType)NativeType.forClass(IStoreCounts.class));
    }

    @NotNull
    public List<Edge> getEdges() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"edges", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class))));
    }

    @NotNull
    public List<Node> getNodes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"nodes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public RootNode getRoot() {
        return (RootNode)Kernel.get((Object)this, (String)"root", (NativeType)NativeType.forClass(RootNode.class));
    }

    @NotNull
    public List<StackNode> getRootStacks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"rootStacks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StackNode.class))));
    }

    @NotNull
    public List<StackNode> getStacks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"stacks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StackNode.class))));
    }

    @NotNull
    public List<StageNode> getStages() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"stages", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StageNode.class))));
    }

    @NotNull
    public String getVersion() {
        return (String)Kernel.get((Object)this, (String)"version", (NativeType)NativeType.forClass(String.class));
    }
}

