/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.payloadoffloading.PayloadStore;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;
import software.amazon.payloadoffloading.Util;
import software.amazon.sns.AmazonSNSExtendedClientBase;
import software.amazon.sns.SNSExtendedClientConfiguration;

public class AmazonSNSExtendedClient
extends AmazonSNSExtendedClientBase {
    static final String MULTIPLE_PROTOCOL_MESSAGE_STRUCTURE = "json";
    private static final Log LOGGER = LogFactory.getLog(AmazonSNSExtendedClient.class);
    private static final String S3_KEY = "S3Key";
    private static final String USER_AGENT_HEADER = Util.getUserAgentHeader((String)AmazonSNSExtendedClient.class.getSimpleName());
    private PayloadStore payloadStore;
    private SNSExtendedClientConfiguration snsExtendedClientConfiguration;

    public AmazonSNSExtendedClient(AmazonSNS snsClient, SNSExtendedClientConfiguration snsExtendedClientConfiguration) {
        super(snsClient);
        this.snsExtendedClientConfiguration = snsExtendedClientConfiguration;
        S3Dao s3Dao = new S3Dao(this.snsExtendedClientConfiguration.getAmazonS3Client());
        this.payloadStore = new S3BackedPayloadStore(s3Dao, this.snsExtendedClientConfiguration.getS3BucketName());
    }

    @Override
    public PublishResult publish(PublishRequest publishRequest) {
        if (publishRequest == null || StringUtils.isNullOrEmpty((String)publishRequest.getMessage())) {
            return super.publish(publishRequest);
        }
        if (!StringUtils.isNullOrEmpty((String)publishRequest.getMessageStructure()) && publishRequest.getMessageStructure().equals(MULTIPLE_PROTOCOL_MESSAGE_STRUCTURE)) {
            String errorMessage = "SNS extended client does not support sending JSON messages.";
            LOGGER.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        publishRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        long messageAttributesSize = this.getMsgAttributesSize(publishRequest.getMessageAttributes());
        long messageBodySize = Util.getStringSizeInBytes((String)publishRequest.getMessage());
        if (!this.shouldExtendedStoreBeUsed(messageAttributesSize + messageBodySize)) {
            return super.publish(publishRequest);
        }
        this.checkMessageAttributes(publishRequest.getMessageAttributes());
        this.checkSizeOfMessageAttributes(messageAttributesSize);
        PublishRequest clonedPublishRequest = this.copyPublishRequest(publishRequest);
        publishRequest = this.storeMessageInExtendedStore(clonedPublishRequest, messageAttributesSize);
        return super.publish(publishRequest);
    }

    @Override
    public PublishResult publish(String topicArn, String message) {
        return this.publish(new PublishRequest().withTopicArn(topicArn).withMessage(message));
    }

    private boolean shouldExtendedStoreBeUsed(long totalMessageSize) {
        return this.snsExtendedClientConfiguration.isAlwaysThroughS3() || this.snsExtendedClientConfiguration.isPayloadSupportEnabled() && this.isTotalMessageSizeLargerThanThreshold(totalMessageSize);
    }

    private void checkMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOGGER.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        MessageAttributeValue largePayloadAttributeName = messageAttributes.get("ExtendedPayloadSize");
        if (largePayloadAttributeName != null) {
            String errorMessage = "Message attribute name ExtendedPayloadSize is reserved for use by SNS extended client.";
            LOGGER.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
    }

    private void checkSizeOfMessageAttributes(long messageAttributeSize) {
        if (messageAttributeSize > (long)this.snsExtendedClientConfiguration.getPayloadSizeThreshold()) {
            String errorMessage = "Total size of Message attributes is " + messageAttributeSize + " bytes which is larger than the threshold of " + this.snsExtendedClientConfiguration.getPayloadSizeThreshold() + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOGGER.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
    }

    private boolean isTotalMessageSizeLargerThanThreshold(long totalMessageSize) {
        return totalMessageSize > (long)this.snsExtendedClientConfiguration.getPayloadSizeThreshold();
    }

    private int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + this.getMessageAttributeSize(entry.getKey(), entry.getValue()));
        }
        return totalMsgAttributesSize;
    }

    private long getMessageAttributeSize(String MessageAttributeKey, MessageAttributeValue value) {
        ByteBuffer binaryVal;
        String stringVal;
        long messageAttributeSize = Util.getStringSizeInBytes((String)MessageAttributeKey);
        if (value.getDataType() != null) {
            messageAttributeSize += Util.getStringSizeInBytes((String)value.getDataType());
        }
        if ((stringVal = value.getStringValue()) != null) {
            messageAttributeSize += Util.getStringSizeInBytes((String)stringVal);
        }
        if ((binaryVal = value.getBinaryValue()) != null) {
            messageAttributeSize += (long)binaryVal.array().length;
        }
        return messageAttributeSize;
    }

    private static String getS3keyAttribute(Map<String, MessageAttributeValue> messageAttributes) {
        if (messageAttributes != null && messageAttributes.containsKey(S3_KEY)) {
            MessageAttributeValue attributeS3KeyValue = messageAttributes.get(S3_KEY);
            return attributeS3KeyValue == null ? null : attributeS3KeyValue.getStringValue();
        }
        return null;
    }

    private PublishRequest storeMessageInExtendedStore(PublishRequest publishRequest, long messageAttributeSize) {
        String messageContentStr = publishRequest.getMessage();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        String s3Key = AmazonSNSExtendedClient.getS3keyAttribute(publishRequest.getMessageAttributes());
        String largeMessagePointer = this.payloadStore.storeOriginalPayload(messageContentStr, messageContentSize, s3Key);
        publishRequest.setMessage(largeMessagePointer);
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("Number");
        messageAttributeValue.setStringValue(messageContentSize.toString());
        publishRequest.addMessageAttributesEntry("ExtendedPayloadSize", messageAttributeValue);
        this.checkSizeOfMessageAttributes(messageAttributeSize += this.getMessageAttributeSize("ExtendedPayloadSize", messageAttributeValue));
        return publishRequest;
    }

    private PublishRequest copyPublishRequest(PublishRequest publishRequest) {
        PublishRequest clonedPublishRequest = publishRequest.clone();
        HashMap attributes = new HashMap(publishRequest.getMessageAttributes());
        clonedPublishRequest.setMessageAttributes(attributes);
        return clonedPublishRequest;
    }
}

