/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.waiters.WaitableTrait;

@SmithyInternalApi
public final class UniqueWaiterNamesValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(ServiceShape.class).flatMap(service -> this.validateService(model, (ServiceShape)service).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        Map<String, Set<OperationShape>> waiterNamesToOperations = this.computeWaiterNamesToOperations(model, service);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry<String, Set<OperationShape>> entry : waiterNamesToOperations.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (OperationShape operation : entry.getValue()) {
                Set conflicts = entry.getValue().stream().filter(o -> !o.equals((Object)operation)).map(Shape::getId).collect(Collectors.toCollection(TreeSet::new));
                events.add(this.error((Shape)operation, (FromSourceLocation)operation.expectTrait(WaitableTrait.class), String.format("`%s` trait waiter name `%s` case-insensitively conflicts with waiters on other operations in the closure of service, `%s`: %s", WaitableTrait.ID, entry.getKey(), service.getId(), conflicts)));
            }
        }
        return events;
    }

    private Map<String, Set<OperationShape>> computeWaiterNamesToOperations(Model model, ServiceShape service) {
        TopDownIndex index = TopDownIndex.of((Model)model);
        TreeMap<String, Set<OperationShape>> waiterNamesToOperations = new TreeMap<String, Set<OperationShape>>();
        for (OperationShape operation : index.getContainedOperations((ToShapeId)service)) {
            operation.getTrait(WaitableTrait.class).ifPresent(trait -> {
                for (String name : trait.getWaiters().keySet()) {
                    Set operations = waiterNamesToOperations.computeIfAbsent(name.toLowerCase(Locale.ENGLISH), n -> new HashSet());
                    operations.add(operation);
                }
            });
        }
        return waiterNamesToOperations;
    }
}

