/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;
import software.amazon.smithy.waiters.Acceptor;

public final class Waiter
implements ToNode,
ToSmithyBuilder<Waiter> {
    private static final String DOCUMENTATION = "documentation";
    private static final String ACCEPTORS = "acceptors";
    private static final String MIN_DELAY = "minDelay";
    private static final String MAX_DELAY = "maxDelay";
    private static final int DEFAULT_MIN_DELAY = 2;
    private static final int DEFAULT_MAX_DELAY = 120;
    private static final Set<String> KEYS = SetUtils.of((Object[])new String[]{"documentation", "acceptors", "minDelay", "maxDelay"});
    private final String documentation;
    private final List<Acceptor> acceptors;
    private final int minDelay;
    private final int maxDelay;

    private Waiter(Builder builder) {
        this.documentation = builder.documentation;
        this.acceptors = ListUtils.copyOf((Collection)builder.acceptors);
        this.minDelay = builder.minDelay;
        this.maxDelay = builder.maxDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SmithyBuilder<Waiter> toBuilder() {
        return Waiter.builder().documentation(this.getDocumentation().orElse(null)).acceptors(this.getAcceptors()).minDelay(this.getMinDelay()).maxDelay(this.getMaxDelay());
    }

    public static Waiter fromNode(Node node) {
        ObjectNode value = node.expectObjectNode().warnIfAdditionalProperties(KEYS);
        Builder builder = Waiter.builder();
        value.getStringMember(DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::documentation);
        for (Node entry : value.expectArrayMember(ACCEPTORS).getElements()) {
            builder.addAcceptor(Acceptor.fromNode(entry));
        }
        value.getNumberMember(MIN_DELAY).map(NumberNode::getValue).map(Number::intValue).ifPresent(builder::minDelay);
        value.getNumberMember(MAX_DELAY).map(NumberNode::getValue).map(Number::intValue).ifPresent(builder::maxDelay);
        return builder.build();
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public List<Acceptor> getAcceptors() {
        return this.acceptors;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember(DOCUMENTATION, this.getDocumentation().map(Node::from)).withMember(ACCEPTORS, (ToNode)((ArrayNode)this.getAcceptors().stream().map(Acceptor::toNode).collect(ArrayNode.collect())));
        if (this.minDelay != 2) {
            builder.withMember(MIN_DELAY, (Number)this.minDelay);
        }
        if (this.maxDelay != 120) {
            builder.withMember(MAX_DELAY, (Number)this.maxDelay);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Waiter)) {
            return false;
        }
        Waiter waiter = (Waiter)o;
        return this.minDelay == waiter.minDelay && this.maxDelay == waiter.maxDelay && Objects.equals(this.documentation, waiter.documentation) && this.acceptors.equals(waiter.acceptors);
    }

    public int hashCode() {
        return Objects.hash(this.documentation, this.acceptors, this.minDelay, this.maxDelay);
    }

    public static final class Builder
    implements SmithyBuilder<Waiter> {
        private String documentation;
        private final List<Acceptor> acceptors = new ArrayList<Acceptor>();
        private int minDelay = 2;
        private int maxDelay = 120;

        private Builder() {
        }

        public Waiter build() {
            return new Waiter(this);
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder clearAcceptors() {
            this.acceptors.clear();
            return this;
        }

        public Builder acceptors(List<Acceptor> acceptors) {
            this.clearAcceptors();
            acceptors.forEach(this::addAcceptor);
            return this;
        }

        public Builder addAcceptor(Acceptor acceptor) {
            this.acceptors.add(Objects.requireNonNull(acceptor));
            return this;
        }

        public Builder minDelay(int minDelay) {
            this.minDelay = minDelay;
            return this;
        }

        public Builder maxDelay(int maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }
    }
}

