/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.waiters.PathComparator;

public final class PathMatcher
implements ToNode {
    private static final String EXPECTED = "expected";
    private static final String PATH = "path";
    private static final String COMPARATOR = "comparator";
    private static final Set<String> KEYS = SetUtils.of((Object[])new String[]{"expected", "path", "comparator"});
    private final String path;
    private final String expected;
    private final PathComparator comparator;

    public PathMatcher(String path, String expected, PathComparator comparator) {
        this.path = path;
        this.expected = expected;
        this.comparator = comparator;
    }

    public String getPath() {
        return this.path;
    }

    public String getExpected() {
        return this.expected;
    }

    public PathComparator getComparator() {
        return this.comparator;
    }

    public static PathMatcher fromNode(Node node) {
        ObjectNode value = node.expectObjectNode().warnIfAdditionalProperties(KEYS);
        return new PathMatcher(value.expectStringMember(PATH).getValue(), value.expectStringMember(EXPECTED).getValue(), PathComparator.fromNode((Node)value.expectStringMember(COMPARATOR)));
    }

    public Node toNode() {
        return Node.objectNode().withMember(PATH, (ToNode)Node.from((String)this.path)).withMember(EXPECTED, (ToNode)Node.from((String)this.expected)).withMember(COMPARATOR, (ToNode)this.comparator.toNode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathMatcher)) {
            return false;
        }
        PathMatcher that = (PathMatcher)o;
        return this.getPath().equals(that.getPath()) && this.getComparator().equals((Object)that.getComparator()) && this.getExpected().equals(that.getExpected());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPath(), this.getComparator(), this.getExpected()});
    }
}

