/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.waiters.AcceptorState;
import software.amazon.smithy.waiters.Matcher;

public final class Acceptor
implements ToNode {
    private static final String STATE = "state";
    private static final String MATCHER = "matcher";
    private static final Set<String> KEYS = SetUtils.of((Object[])new String[]{"state", "matcher"});
    private final AcceptorState state;
    private final Matcher<?> matcher;

    public Acceptor(AcceptorState state, Matcher<?> matcher) {
        this.state = state;
        this.matcher = matcher;
    }

    public AcceptorState getState() {
        return this.state;
    }

    public Matcher<?> getMatcher() {
        return this.matcher;
    }

    public static Acceptor fromNode(Node node) {
        ObjectNode value = node.expectObjectNode().warnIfAdditionalProperties(KEYS);
        return new Acceptor(AcceptorState.fromNode((Node)value.expectStringMember(STATE)), Matcher.fromNode(value.expectMember(MATCHER)));
    }

    public Node toNode() {
        return Node.objectNode().withMember(STATE, (ToNode)Node.from((String)this.state.toString())).withMember(MATCHER, (ToNode)this.matcher.toNode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Acceptor)) {
            return false;
        }
        Acceptor acceptor = (Acceptor)o;
        return this.getState() == acceptor.getState() && Objects.equals(this.getMatcher(), acceptor.getMatcher());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getState(), this.getMatcher()});
    }
}

