/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;

public enum PathComparator implements ToNode
{
    ALL_STRING_EQUALS("allStringEquals"),
    ANY_STRING_EQUALS("anyStringEquals"),
    STRING_EQUALS("stringEquals"),
    BOOLEAN_EQUALS("booleanEquals");

    private final String asString;

    private PathComparator(String asString) {
        this.asString = asString;
    }

    public static PathComparator fromNode(Node node) {
        String value = node.expectStringNode().getValue();
        for (PathComparator comparator : PathComparator.values()) {
            if (!comparator.toString().equals(value)) continue;
            return comparator;
        }
        throw new ExpectationNotMetException("Expected valid path comparator, but found " + value, (FromSourceLocation)node);
    }

    public String toString() {
        return this.asString;
    }

    public Node toNode() {
        return Node.from((String)this.toString());
    }
}

