/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;
import software.amazon.smithy.waiters.Waiter;

public final class WaitableTrait
extends AbstractTrait
implements ToSmithyBuilder<WaitableTrait> {
    public static final ShapeId ID = ShapeId.from((String)"smithy.waiters#waitable");
    private final Map<String, Waiter> waiters;

    private WaitableTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.waiters = MapUtils.orderedCopyOf((Map)builder.waiters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SmithyBuilder<WaitableTrait> toBuilder() {
        return ((Builder)new Builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).replace(this.waiters);
    }

    public Map<String, Waiter> getWaiters() {
        return this.waiters;
    }

    protected Node createNode() {
        ObjectNode.Builder builder = ObjectNode.objectNodeBuilder();
        builder.sourceLocation(this.getSourceLocation());
        for (Map.Entry<String, Waiter> entry : this.waiters.entrySet()) {
            builder.withMember(entry.getKey(), (ToNode)entry.getValue().toNode());
        }
        return builder.build();
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode node = value.expectObjectNode();
            Builder builder = (Builder)WaitableTrait.builder().sourceLocation((FromSourceLocation)value);
            for (Map.Entry entry : node.getStringMap().entrySet()) {
                builder.put((String)entry.getKey(), Waiter.fromNode((Node)entry.getValue()));
            }
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<WaitableTrait, Builder> {
        private final Map<String, Waiter> waiters = new LinkedHashMap<String, Waiter>();

        private Builder() {
        }

        public WaitableTrait build() {
            return new WaitableTrait(this);
        }

        public Builder put(String name, Waiter value) {
            this.waiters.put(name, value);
            return this;
        }

        public Builder clear() {
            this.waiters.clear();
            return this;
        }

        public Builder replace(Map<String, Waiter> waiters) {
            this.clear();
            this.waiters.putAll(waiters);
            return this;
        }
    }
}

