/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import software.amazon.smithy.utils.StringUtils;

public final class CaseUtils {
    private CaseUtils() {
    }

    public static String snakeToPascalCase(String str) {
        return CaseUtils.toCamelCase(str, true, '_');
    }

    public static String snakeToCamelCase(String str) {
        return CaseUtils.toCamelCase(str, false, '_');
    }

    public static String toCamelCase(String str) {
        return CaseUtils.toCamelCase(str, false, '_', '-', ' ');
    }

    public static String toPascalCase(String str) {
        return CaseUtils.toCamelCase(str, true, '_', '-', ' ');
    }

    public static String toCamelCase(String str, boolean capitalizeFirstLetter, char ... delimiters) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = str.toLowerCase();
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        Set<Integer> delimiterSet = CaseUtils.generateDelimiterSet(delimiters);
        boolean capitalizeNext = false;
        if (capitalizeFirstLetter) {
            capitalizeNext = true;
        }
        int index = 0;
        while (index < strLen) {
            int codePoint = str.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                capitalizeNext = true;
                if (outOffset == 0) {
                    capitalizeNext = false;
                }
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext || outOffset == 0 && capitalizeFirstLetter) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        if (outOffset != 0) {
            return new String(newCodePoints, 0, outOffset);
        }
        return str;
    }

    private static Set<Integer> generateDelimiterSet(char[] delimiters) {
        HashSet<Integer> delimiterHashSet = new HashSet<Integer>();
        delimiterHashSet.add(Character.codePointAt(new char[]{' '}, 0));
        if (delimiters == null || delimiters.length == 0) {
            return delimiterHashSet;
        }
        for (int index = 0; index < delimiters.length; ++index) {
            delimiterHashSet.add(Character.codePointAt(delimiters, index));
        }
        return delimiterHashSet;
    }

    public static String toSnakeCase(String word) {
        if (StringUtils.isEmpty(word)) {
            return word;
        }
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replaceAll("(\\s|-)", "_");
        word = word.toLowerCase(Locale.US);
        return word;
    }
}

