/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

public interface SmithyBuilder<T> {
    public T build();

    public static <T> T requiredState(String method, T value) {
        if (value == null) {
            StringBuilder message = new StringBuilder(method).append(" was not set on the builder");
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            if (elements.length >= 2) {
                String builder = elements[2].getClassName();
                message.append(" (builder class is probably ").append(builder).append(')');
            }
            throw new IllegalStateException(message.toString());
        }
        return value;
    }
}

