/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.CodeInterceptor;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class CodeInterceptorContainer<W extends AbstractCodeWriter<W>> {
    private final List<CodeInterceptor<CodeSection, W>> interceptors = new ArrayList<CodeInterceptor<CodeSection, W>>();
    private final CodeInterceptorContainer<W> parent;

    CodeInterceptorContainer() {
        this(null);
    }

    CodeInterceptorContainer(CodeInterceptorContainer<W> parent) {
        this.parent = parent;
    }

    void putInterceptor(CodeInterceptor<? extends CodeSection, W> interceptor) {
        this.interceptors.add(interceptor);
    }

    <S extends CodeSection> List<CodeInterceptor<CodeSection, W>> get(S forSection) {
        ArrayList<CodeInterceptor<CodeSection, W>> result = this.parent == null ? new ArrayList() : this.parent.get(forSection);
        for (CodeInterceptor<CodeSection, W> interceptor : this.interceptors) {
            if (!interceptor.sectionType().isInstance(forSection) || !interceptor.isIntercepted(forSection)) continue;
            result.add(interceptor);
        }
        return result;
    }
}

