/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Objects;
import java.util.function.Predicate;

public class SimpleParser {
    private final String expression;
    private final int length;
    private final int maxNestingLevel;
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private int nestingLevel = 0;

    public SimpleParser(String expression) {
        this(expression, 0);
    }

    public SimpleParser(String expression, int maxNestingLevel) {
        this.expression = Objects.requireNonNull(expression, "expression must not be null");
        this.length = expression.length();
        if (maxNestingLevel < 0) {
            throw new IllegalArgumentException("maxNestingLevel must be >= 0");
        }
        this.maxNestingLevel = maxNestingLevel;
    }

    public final String expression() {
        return this.expression;
    }

    public final int position() {
        return this.position;
    }

    public final int line() {
        return this.line;
    }

    public final int column() {
        return this.column;
    }

    public final void rewind(int position, int line, int column) {
        this.column = column;
        this.line = line;
        this.position = position;
    }

    public final boolean eof() {
        return this.position >= this.length;
    }

    public final char peek() {
        return this.peek(0);
    }

    public final char peek(int offset) {
        int target = this.position + offset;
        if (target >= this.length || target < 0) {
            return '\u0000';
        }
        return this.expression.charAt(target);
    }

    public final char expect(char token) {
        if (this.peek() == token) {
            this.skip();
            return token;
        }
        throw this.syntax(String.format("Expected: '%s', but found '%s'", Character.valueOf(token), this.peekSingleCharForMessage()));
    }

    public final String peekSingleCharForMessage() {
        char peek = this.peek();
        return peek == '\u0000' ? "[EOF]" : String.valueOf(peek);
    }

    public final char expect(char ... tokens) {
        for (char token : tokens) {
            if (this.peek() != token) continue;
            this.skip();
            return token;
        }
        StringBuilder message = new StringBuilder("Found '").append(this.peekSingleCharForMessage()).append("', but expected one of the following tokens:");
        for (char c : tokens) {
            message.append(' ').append('\'').append(c).append('\'');
        }
        throw this.syntax(message.toString());
    }

    public RuntimeException syntax(String message) {
        return new RuntimeException("Syntax error at line " + this.line() + " column " + this.column() + ": " + message);
    }

    public void ws() {
        while (!this.eof() && this.isWhitespace(this.peek())) {
            this.skip();
        }
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void sp() {
        while (!this.eof() && this.isSpace(this.peek())) {
            this.skip();
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public void br() {
        this.sp();
        if (this.eof()) {
            return;
        }
        char c = this.peek();
        if (c != '\n' && c != '\r') {
            throw this.syntax("Expected a line break, but found '" + c + "'");
        }
        this.skip();
    }

    public void skip() {
        if (this.eof()) {
            return;
        }
        switch (this.expression.charAt(this.position)) {
            case '\r': {
                if (this.peek(1) == '\n') {
                    ++this.position;
                }
                ++this.line;
                this.column = 1;
                break;
            }
            case '\n': {
                ++this.line;
                this.column = 1;
                break;
            }
            default: {
                ++this.column;
            }
        }
        ++this.position;
    }

    public void consumeRemainingCharactersOnLine() {
        this.consumeUntilNoLongerMatches(c -> c.charValue() != '\n' && c.charValue() != '\r');
    }

    public final String sliceFrom(int start) {
        return this.expression().substring(start, this.position);
    }

    public final int consumeUntilNoLongerMatches(Predicate<Character> predicate) {
        char peekedChar;
        int startPosition = this.position;
        while (!this.eof() && predicate.test(Character.valueOf(peekedChar = this.peek()))) {
            this.skip();
        }
        return this.position - startPosition;
    }

    public final void increaseNestingLevel() {
        ++this.nestingLevel;
        if (this.maxNestingLevel > 0 && this.nestingLevel > this.maxNestingLevel) {
            throw this.syntax("Parser exceeded the maximum allowed depth of " + this.maxNestingLevel);
        }
    }

    public final void decreaseNestingLevel() {
        --this.nestingLevel;
        if (this.nestingLevel < 0) {
            throw this.syntax("Invalid parser state. Nesting level set to -1");
        }
    }

    public int nestingLevel() {
        return this.nestingLevel;
    }
}

