/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import software.amazon.smithy.utils.CodeWriter;
import software.amazon.smithy.utils.SetUtils;

final class CodeFormatter {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z]+[a-zA-Z0-9_.#$]*$");
    private static final Set<Character> VALID_FORMATTER_CHARS = SetUtils.of(Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'));
    private final Map<Character, BiFunction<Object, String, String>> formatters = new HashMap<Character, BiFunction<Object, String, String>>();

    CodeFormatter() {
    }

    void putFormatter(Character identifier, BiFunction<Object, String, String> formatter) {
        if (!VALID_FORMATTER_CHARS.contains(identifier)) {
            throw new IllegalArgumentException("Invalid formatter identifier: " + identifier);
        }
        this.formatters.put(identifier, formatter);
    }

    String format(Object content, String indent, CodeWriter writer, Object ... args) {
        String expression = String.valueOf(content);
        if (args.length == 0 && expression.indexOf(36) == -1) {
            return expression;
        }
        return this.parse(new State(content, indent, writer, args));
    }

    private String parse(State state) {
        while (!state.eof()) {
            char c = state.c();
            state.next();
            if (c == '$') {
                this.parseArgumentWrapper(state);
                continue;
            }
            state.result.append(c);
        }
        if (state.relativeIndex == -1) {
            CodeFormatter.ensureAllPositionalArgumentsWereUsed(state.expression, state.positionals);
        } else if (state.relativeIndex < state.args.length) {
            throw new IllegalArgumentException(String.format("Found %d unused relative format arguments: %s", state.args.length - state.relativeIndex, state.expression));
        }
        return state.result.toString();
    }

    private void parseArgumentWrapper(State state) {
        if (state.eof()) {
            throw new IllegalArgumentException("Invalid format string: " + state);
        }
        char c = state.c();
        if (c == '$') {
            state.result.append('$');
            state.next();
        } else if (c == '{') {
            this.parseBracedArgument(state);
        } else {
            this.parseArgument(state, false);
        }
    }

    private void parseBracedArgument(State state) {
        state.next();
        this.parseArgument(state, true);
        if (state.c() != '}') {
            throw new IllegalArgumentException("Unclosed expression argument: " + state);
        }
        state.next();
    }

    private void parseArgument(State state, boolean insideBrace) {
        if (state.eof()) {
            throw new IllegalArgumentException("Invalid format string: " + state);
        }
        char c = state.c();
        if (Character.isLowerCase(c)) {
            this.parseNamedArgument(state, insideBrace);
        } else if (Character.isDigit(c)) {
            this.parsePositionalArgument(state, insideBrace);
        } else {
            this.parseRelativeArgument(state, insideBrace);
        }
    }

    private void parseNamedArgument(State state, boolean insideBrace) {
        String name = this.parseNameUntil(state, ':');
        state.next();
        if (state.eof()) {
            throw new IllegalArgumentException("Expected an identifier after the ':' in a named argument: " + state);
        }
        char identifier = this.consumeFormatterIdentifier(state);
        state.result.append(this.applyFormatter(state, identifier, state.writer.getContext(name), insideBrace));
    }

    private char consumeFormatterIdentifier(State state) {
        char identifier = state.c();
        state.next();
        return identifier;
    }

    private void parsePositionalArgument(State state, boolean insideBrace) {
        CodeFormatter.expectConsistentRelativePositionals(state, state.relativeIndex <= 0);
        state.relativeIndex = -1;
        int startPosition = state.position;
        while (state.next() && Character.isDigit(state.c())) {
        }
        int index = Integer.parseInt(state.expression.substring(startPosition, state.position)) - 1;
        if (index < 0 || index >= state.args.length) {
            throw new IllegalArgumentException(String.format("Positional argument index %d out of range of provided %d arguments in format string: %s", index, state.args.length, state));
        }
        Object arg = this.getPositionalArgument(state.expression, index, state.args);
        state.positionals[index] = true;
        char identifier = this.consumeFormatterIdentifier(state);
        state.result.append(this.applyFormatter(state, identifier, arg, insideBrace));
    }

    private void parseRelativeArgument(State state, boolean insideBrace) {
        CodeFormatter.expectConsistentRelativePositionals(state, state.relativeIndex > -1);
        ++state.relativeIndex;
        Object argument = this.getPositionalArgument(state.expression, state.relativeIndex - 1, state.args);
        char identifier = this.consumeFormatterIdentifier(state);
        state.result.append(this.applyFormatter(state, identifier, argument, insideBrace));
    }

    private String parseNameUntil(State state, char endToken) {
        int endIndex = state.expression.indexOf(endToken, state.position);
        if (endIndex == -1) {
            throw new IllegalArgumentException("Invalid named format argument: " + state);
        }
        String name = state.expression.substring(state.position, endIndex);
        CodeFormatter.ensureNameIsValid(state, name);
        state.position = endIndex;
        return name;
    }

    private static void expectConsistentRelativePositionals(State state, boolean expectation) {
        if (!expectation) {
            throw new IllegalArgumentException("Cannot mix positional and relative arguments: " + state);
        }
    }

    private static void ensureAllPositionalArgumentsWereUsed(String expression, boolean[] positionals) {
        int unused = 0;
        for (boolean b : positionals) {
            if (b) continue;
            ++unused;
        }
        if (unused > 0) {
            throw new IllegalArgumentException(String.format("Found %d unused positional format arguments: %s", unused, expression));
        }
    }

    private Object getPositionalArgument(String content, int index, Object[] args) {
        if (index >= args.length) {
            throw new IllegalArgumentException(String.format("Given %d arguments but attempted to format index %d: %s", args.length, index, content));
        }
        return args[index];
    }

    private String applyFormatter(State state, char formatter, Object argument, boolean inBrace) {
        if (!this.formatters.containsKey(Character.valueOf(formatter))) {
            throw new IllegalArgumentException(String.format("Unknown formatter `%s` found in format string: %s", Character.valueOf(formatter), state));
        }
        String result = this.formatters.get(Character.valueOf(formatter)).apply(argument, state.indent);
        if (!state.eof() && state.c() == '@') {
            if (!inBrace) {
                throw new IllegalArgumentException("Inline blocks can only be created inside braces: " + state);
            }
            result = this.expandInlineSection(state, result);
        }
        return result;
    }

    private String expandInlineSection(State state, String argument) {
        state.next();
        String sectionName = this.parseNameUntil(state, '}');
        CodeFormatter.ensureNameIsValid(state, sectionName);
        return state.writer.expandSection(sectionName, argument, s -> state.writer.write(s, new Object[0]));
    }

    private static void ensureNameIsValid(State state, String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Invalid format expression name `%s` at position %d of: %s", name, state.position + 1, state));
        }
    }

    private static final class State {
        StringBuilder result = new StringBuilder();
        int position = 0;
        int relativeIndex = 0;
        CodeWriter writer;
        String expression;
        String indent;
        Object[] args;
        boolean[] positionals;

        State(Object expression, String indent, CodeWriter writer, Object[] args) {
            this.expression = String.valueOf(expression);
            this.indent = indent;
            this.writer = writer;
            this.args = args;
            this.positionals = new boolean[args.length];
        }

        char c() {
            return this.expression.charAt(this.position);
        }

        boolean eof() {
            return this.position >= this.expression.length();
        }

        boolean next() {
            return ++this.position < this.expression.length() - 1;
        }

        public String toString() {
            return this.expression;
        }
    }
}

