/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits.eventstream;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.protocoltests.traits.eventstream.EventHeaderValue;
import software.amazon.smithy.protocoltests.traits.eventstream.EventType;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Event
implements ToSmithyBuilder<Event> {
    private final EventType type;
    private final ObjectNode params;
    private final Map<String, EventHeaderValue<?>> headers;
    private final List<String> forbidHeaders;
    private final List<String> requireHeaders;
    private final String body;
    private final String bodyMediaType;
    private final byte[] bytes;
    private final ObjectNode vendorParams;
    private final ShapeId vendorParamsShape;

    private Event(Builder builder) {
        this.type = (EventType)((Object)SmithyBuilder.requiredState((String)"type", (Object)((Object)builder.type)));
        this.params = builder.params;
        this.headers = (Map)builder.headers.copy();
        this.forbidHeaders = (List)builder.forbidHeaders.copy();
        this.requireHeaders = (List)builder.requireHeaders.copy();
        this.body = builder.body;
        this.bodyMediaType = builder.bodyMediaType;
        this.bytes = builder.bytes;
        this.vendorParams = builder.vendorParams;
        this.vendorParamsShape = builder.vendorParamsShape;
    }

    public EventType getType() {
        return this.type;
    }

    public Optional<ObjectNode> getParams() {
        return Optional.ofNullable(this.params);
    }

    public Map<String, EventHeaderValue<?>> getHeaders() {
        return this.headers;
    }

    public List<String> getForbidHeaders() {
        return this.forbidHeaders;
    }

    public List<String> getRequireHeaders() {
        return this.requireHeaders;
    }

    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> getBodyMediaType() {
        return Optional.ofNullable(this.bodyMediaType);
    }

    public Optional<byte[]> getBytes() {
        return Optional.ofNullable(this.bytes);
    }

    public Optional<ObjectNode> getVendorParams() {
        return Optional.ofNullable(this.vendorParams);
    }

    public Optional<ShapeId> getVendorParamsShape() {
        return Optional.ofNullable(this.vendorParamsShape);
    }

    public SmithyBuilder<Event> toBuilder() {
        return new Builder().type(this.type).params(this.params).headers(this.headers).forbidHeaders(this.forbidHeaders).requireHeaders(this.requireHeaders).body(this.body).bodyMediaType(this.bodyMediaType).bytes(this.bytes).vendorParams(this.vendorParams).vendorParamsShape(this.vendorParamsShape);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        return this.type == event.type && Objects.equals(this.params, event.params) && Objects.equals(this.headers, event.headers) && Objects.equals(this.forbidHeaders, event.forbidHeaders) && Objects.equals(this.requireHeaders, event.requireHeaders) && Objects.equals(this.body, event.body) && Objects.equals(this.bodyMediaType, event.bodyMediaType) && Objects.deepEquals(this.bytes, event.bytes) && Objects.equals(this.vendorParams, event.vendorParams) && Objects.equals(this.vendorParamsShape, event.vendorParamsShape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.params, this.headers, this.forbidHeaders, this.requireHeaders, this.body, this.bodyMediaType, Arrays.hashCode(this.bytes), this.vendorParams, this.vendorParamsShape});
    }

    public static final class Builder
    implements SmithyBuilder<Event> {
        private EventType type;
        private ObjectNode params;
        private final BuilderRef<Map<String, EventHeaderValue<?>>> headers = BuilderRef.forOrderedMap();
        private final BuilderRef<List<String>> forbidHeaders = BuilderRef.forList();
        private final BuilderRef<List<String>> requireHeaders = BuilderRef.forList();
        private String body;
        private String bodyMediaType;
        private byte[] bytes;
        private ObjectNode vendorParams;
        private ShapeId vendorParamsShape;

        public Event build() {
            return new Event(this);
        }

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder params(ObjectNode params) {
            this.params = params;
            return this;
        }

        public Builder headers(Map<String, EventHeaderValue<?>> headers) {
            this.headers.clear();
            ((Map)this.headers.get()).putAll(headers);
            return this;
        }

        public Builder forbidHeaders(List<String> forbidHeaders) {
            this.forbidHeaders.clear();
            ((List)this.forbidHeaders.get()).addAll(forbidHeaders);
            return this;
        }

        public Builder requireHeaders(List<String> requireHeaders) {
            this.requireHeaders.clear();
            ((List)this.requireHeaders.get()).addAll(requireHeaders);
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder bodyMediaType(String bodyMediaType) {
            this.bodyMediaType = bodyMediaType;
            return this;
        }

        public Builder bytes(String bytes) {
            this.bytes = (byte[])(bytes == null ? null : Base64.getDecoder().decode(bytes.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        public Builder bytes(byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder vendorParams(ObjectNode vendorParams) {
            this.vendorParams = vendorParams;
            return this;
        }

        public Builder vendorParamsShape(ShapeId vendorParamsShape) {
            this.vendorParamsShape = vendorParamsShape;
            return this;
        }
    }
}

